﻿using System;
using System.Data;
using System.Configuration;

/// <summary>
/// PaperTitleNumberManager 的摘要说明
/// </summary>
public class PaperTitleNumberManager
{
    private PaperTitleNumberDAO paperTitleNumberDao;
    private PaperInformationDAO paperInformationDao;

    public PaperTitleNumberManager()
    {
        paperTitleNumberDao = new PaperTitleNumberDAO();
        paperInformationDao = new PaperInformationDAO();
    }

    public void AddTitle(PaperTitleNumber newPaperTitleNumber, string courseId,int paperId)
    {
        bool flag = HasThisType(newPaperTitleNumber.PaperID, newPaperTitleNumber.TitleType);

        if (flag)
        {
            UpdateNumber(newPaperTitleNumber.TitleType, newPaperTitleNumber.TitleNumber, newPaperTitleNumber.PaperID);
            paperInformationDao.UpdateTitles(newPaperTitleNumber, courseId, paperId);
        }
        else
        {
            Insert(newPaperTitleNumber);
            paperInformationDao.UpdateTitles(newPaperTitleNumber, courseId, paperId);
        }  

    }

    /// <summary>
    /// Inserts a new PaperTitleNumber
    /// </summary>
    /// <param name="PaperTitleNumber">PaperTitleNumber</param>
    public int Insert(PaperTitleNumber newPaperTitleNumber)
    {
        return paperTitleNumberDao.Insert(newPaperTitleNumber);
    }

    public bool HasThisType(int parentId,string titleType) 
    {
        int count = paperTitleNumberDao.GetTitleNumberByType(parentId,titleType);
        if (count > 0)
        {
            return true;
        }

        return false;
    }

    public void UpdateNumber(string titleType,int titleNumber,int parentId)
    {
        paperTitleNumberDao.AddTitleNumber(titleType,titleNumber,parentId);
    }
}
