﻿using System;
using System.Data;
using System.Configuration;
using System.Collections.Generic;
using System.Text;

using core.BusinessObject;


namespace core.BusinessLogicLayer
{
    /// <summary>
    /// SubjectManager 的摘要说明
    /// </summary>
    public class SubjectManager
    {
        private SubjectDataAccess subjectDao;

        public SubjectManager()
        {
            this.subjectDao = new SubjectDataAccess();
        }

        public  DataSet SelectCourseName()
        {
            return subjectDao.SelectCourseName();
        }

        public  DataSet SelectType()
        {
            return subjectDao.SelectType();
        }

        public  int Insert(Subject objSubject)
        {
            return subjectDao.Insert(objSubject);
        }

        public int Delete(Subject objSubject)
        {
            return subjectDao.Delete(objSubject);
        }

        public List<Subject> Search(string courseName, string themeType, string courseChapter)
        {
            return subjectDao.Search(courseName, themeType, courseChapter);
        }

        public int GetAllCount()
        {
            return subjectDao.GetAllCount();
        }

        /// <summary>
        /// Retrieves all teachers
        /// 分页查询教师信息
        /// </summary>
        /// <returns>json格式的数据</returns>
        public string SearchPaging(int start, int limit)
        {
             StringBuilder stringBuilder = new StringBuilder();
             //设置文档头
             //stringBuilder.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
             stringBuilder.Append("<dataset>");
             stringBuilder.Append("<results>" + subjectDao.GetAllCount() + "</results>");

             List<Subject> subjects = subjectDao.SearchPaging(start, limit);

             foreach (Subject subject in subjects)
             {
                 stringBuilder.Append("<row>");

                 stringBuilder.Append("<subjectID>" + subject.SubjectID.Trim() + "</subjectID>");
                 stringBuilder.Append("<courseName>" + subject.CourseName.Trim() + "</courseName>");
                 stringBuilder.Append("<themeName>" + subject.ThemeName.Trim() + "</themeName>");
                 stringBuilder.Append("<subjectContent>" + "<![CDATA[" + subject.SubjectContent.Trim() + "]]></subjectContent>");
                 stringBuilder.Append("<subjectAnswer>" + "<![CDATA[" + subject.SubjectAnswer.Trim() + "]]></subjectAnswer>");
                 stringBuilder.Append("<courseChapter>" + subject.CourseChapter.Trim() + "</courseChapter>");
                 stringBuilder.Append("<difficultFactor>" + subject.DifficultFactor.Trim() + "</difficultFactor>");
                 stringBuilder.Append("<Id>" + subject.Id.ToString().Trim() + "</Id>");

                 stringBuilder.Append("</row>");
             }

             stringBuilder.Append("</dataset>");

             return stringBuilder.ToString();
         }

        public List<Subject> GetPaper(int paperId)
        {
            return subjectDao.SearchTitles(paperId);

        }
        
         /// <summary>
         /// Retrieves all teachers
         /// 分页查询教师信息
         /// </summary>
         /// <returns>json格式的数据</returns>
        public string GetTitles(int paperId)
        {
            StringBuilder stringBuilder = new StringBuilder();
            //设置文档头
            //stringBuilder.Append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            stringBuilder.Append("<dataset>");

            List<Subject> subjects = subjectDao.SearchTitles(paperId);
            stringBuilder.Append("<results>" + subjects.Count + "</results>");

            foreach (Subject subject in subjects)
            {
                stringBuilder.Append("<row>");

                stringBuilder.Append("<subjectID>" + subject.SubjectID.Trim() + "</subjectID>");
                stringBuilder.Append("<courseName>" + subject.CourseName.Trim() + "</courseName>");
                stringBuilder.Append("<themeName>" + subject.ThemeName.Trim() + "</themeName>");
                stringBuilder.Append("<subjectContent>" + "<![CDATA[" + subject.SubjectContent.Trim() + "]]></subjectContent>");
                stringBuilder.Append("<subjectAnswer>" + "<![CDATA[" + subject.SubjectAnswer.Trim() + "]]></subjectAnswer>");
                stringBuilder.Append("<courseChapter>" + subject.CourseChapter.Trim() + "</courseChapter>");
                stringBuilder.Append("<difficultFactor>" + subject.DifficultFactor.Trim() + "</difficultFactor>");
                stringBuilder.Append("<id>" + subject.Id.ToString().Trim() + "</id>");

                stringBuilder.Append("</row>");
            }

            stringBuilder.Append("</dataset>");

            return stringBuilder.ToString();
        }

        public int Update(Subject objSubject)
        {
            return subjectDao.Update(objSubject);
        }

        public void AddSubjectType(string explain,string type)
        {
            subjectDao.AddSubjectType(explain, type);
        }

        public DataSet SearchSubject(string subjectID)
        {
            return subjectDao.SearchSubject(subjectID);
        }

    }
}
