﻿using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;
using System.Data.SqlClient;

using Paper.BusinessObject;
using Sky.Darkness.Commons.DataAccess;

namespace Paper.DataAccessLayer
{
    /// <summary>
    /// TeacherDAO 的摘要说明
    /// </summary>
    public class TeacherDAO_bak
    {
        private static readonly string _connectionString = string.Empty;

        /// <summary>
        /// Selects all teachers from the database
        /// </summary>
        public static List<Teacher> SelectAll()
        {
            // Create teacher collection
            List<Teacher> colTeachers = new List<Teacher>();

            // Create connection
            SqlConnection con = new SqlConnection(_connectionString);

            // Create command
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = "SELECT teacherID,teacherName,departmentID FROM Teacher";

            // Execute command
            using (con)
            {
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    //colTeachers.Add(new Teacher(
                    //    (string)reader["teacherID"],
                      //  (string)reader["teacherName"],
                        //(string)reader["departmentID"]));
                }
            }
            return colTeachers;
        }

        /// <summary>
        /// Selects all teachers from the database
        /// </summary>
        public static List<Teacher> SearchPaging(int start, int limit)
        {
            // Create teacher collection
            List<Teacher> colTeachers = new List<Teacher>();

            // Create connection
            SqlConnection con = new SqlConnection(_connectionString);

            // Create command
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = "SELECT TOP " + limit + " teacherID,teacherName,departmentID FROM Teacher"
                            + " WHERE teacherID NOT IN("
                            + " SELECT TOP " + start + " teacherID FROM Teacher ORDER BY teacherID ASC) ORDER BY teacherID ASC";

            //"SELECT [teacherID], [teacherName], [teachingDepartment], teacher.departmentID, [departmentName] "
              //               + "FROM [teacher] JOIN [department]  ON department.departmentID = teacher.departmentID "
                //             + "WHERE teacher.departmentID=@departmentID";

            // Execute command
            using (con)
            {
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    //colTeachers.Add(new Teacher(
                    //    (string)reader["teacherID"],
                    //    (string)reader["teacherName"],
                    //    (string)reader["departmentID"]));
                }
            }
            return colTeachers;
        }

        public static int GetAllCount()
        {
            string sqlStr = "SELECT COUNT(*) FROM Teacher";
            return (int)SqlHelper.ExecuteScalar(sqlStr);
        }

        /// <summary>
        /// Selects all teachers in a department from the database
        /// </summary>
        public static List<Teacher> SelectAll(string departmentID)
        {
            // Create teacher collection
            List<Teacher> colTeachers = new List<Teacher>();

            if (departmentID == null)
                return colTeachers;

            // Create connection
            SqlConnection con = new SqlConnection(_connectionString);

            // Create command
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            //cmd.CommandText = "SELECT teacherID,teacherName,departmentID FROM Teacher WHERE departmentID=@departmentID";
            cmd.CommandText = "SELECT [teacherID], [teacherName], [teachingDepartment], teacher.departmentID, [departmentName] "
                             + "FROM [teacher] JOIN [department]  ON department.departmentID = teacher.departmentID "
                             + "WHERE teacher.departmentID=@departmentID";
            // Add parameters
            cmd.Parameters.AddWithValue("@departmentID", departmentID);

            // Execute command
            using (con)
            {
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    //colTeachers.Add(new Teacher(
                    //    (string)reader["teacherID"],
                   //     (string)reader["teacherName"],
                   //     (string)reader["departmentID"]));
                }
            }
            return colTeachers;
        }

        /// <summary>
        /// Inserts a new teacher into the database
        /// </summary>
        /// <param name="newTeacher">Teacher</param>
        public static void Insert(Teacher newTeacher)
        {
            // Create connection
            SqlConnection con = new SqlConnection(_connectionString);

            // Create command
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = "INSERT Teacher (teacherID,teacherName,departmentID) VALUES (@TeacherID,@TeacherName,@DepartmentID)";

            // Add parameters
            cmd.Parameters.AddWithValue("@TeacherID", newTeacher.TeacherID);
            cmd.Parameters.AddWithValue("@TeacherName", newTeacher.TeacherName);
            cmd.Parameters.AddWithValue("@DepartmentID", newTeacher.DepartmentID);

            // Execute command
            using (con)
            {
                con.Open();
                cmd.ExecuteNonQuery();
            }
        }

        /// <summary>
        /// Updates an existing teacher into the database
        /// </summary>
        /// <param name="teacherToUpdate">Teacher</param>
        public static void Update(Teacher teacherToUpdate)
        {
            // Create connection
            SqlConnection con = new SqlConnection(_connectionString);

            // Create command
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = "UPDATE Teacher SET TeacherName=@TeacherName,DepartmentID=@DepartmentID WHERE TeacherID=@TeacherID";

            // Add parameters
            cmd.Parameters.AddWithValue("@TeacherName", teacherToUpdate.TeacherName);
            cmd.Parameters.AddWithValue("@DepartmentID", teacherToUpdate.DepartmentID);
            cmd.Parameters.AddWithValue("@TeacherID", teacherToUpdate.TeacherID);

            // Execute command
            using (con)
            {
                con.Open();
                cmd.ExecuteNonQuery();
            }
        }

        /// <summary>
        /// Deletes an existing teacher in the database
        /// </summary>
        /// <param name="teacherID">Teacher Id</param>
        public static void Delete(string teacherID)
        {
            // Create connection
            SqlConnection con = new SqlConnection(_connectionString);

            // Create command
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = "DELETE Teacher WHERE TeacherID=@TeacherID";

            // Add parameters
            cmd.Parameters.AddWithValue("@TeacherID", teacherID);

            // Execute command
            using (con)
            {
                con.Open();
                cmd.ExecuteNonQuery();
            }
        }

        /// <summary>
        /// Initialize the data access layer by
        /// loading the database connection string from 
        /// the Web.Config file
        /// </summary>
        static TeacherDAO_bak()
        {
            _connectionString = ConfigurationManager.AppSettings["GlobalConnectionString"];
            if (string.IsNullOrEmpty(_connectionString))
                throw new Exception("No connection string configured in Web.Config file");
        }
    }
}