﻿using System;
using System.Data;
using System.Configuration;

using Sky.Darkness.Commons.DataAccess;
using Sky.Darkness.Commons.Util;

/// <summary>
/// PaperInformationDAO 的摘要说明
/// </summary>
public class PaperInformationDAO : GenericDaoSql<PaperInformation, string>
{
    public PaperInformationDAO()
    {
    }

    public void UpdateTitles(PaperTitleNumber newPaperTitleNumber, string courseId,int paperId)
    {
        /**
         * 取出符合条件的题目编号
         */
        string strSqlSubjectID = "SELECT subjectID FROM course,theme,subjectStoreRoom " +
           " WHERE course.courseID=subjectStoreRoom.courseID AND theme.themeID=subjectStoreRoom.themeID " +
           " AND course.courseId ='" + courseId.Trim() + 
           "' AND theme.themeType LIKE '%" + newPaperTitleNumber.TitleType + "%' " + 
           " AND courseChapter >= " + newPaperTitleNumber.CourseChapterFrom + 
           " AND courseChapter <=" + newPaperTitleNumber.CourseChapterTo +
           " AND subjectStoreRoom.difficultFactor LIKE '%" + newPaperTitleNumber.DifficultFactor + "%'";
        DataSet subjectIds = SqlHelper.FillDataSet(strSqlSubjectID, null, CommandType.Text);
        int[] arrSubjectIds = new int[subjectIds.Tables[0].Rows.Count];
        for (int i = 0; i < subjectIds.Tables[0].Rows.Count; i++)
        {
            arrSubjectIds[i] = (int)subjectIds.Tables[0].Rows[i][0];
        }

        /**
         * 取出该试卷中已经存在的题目
         * ,存放在 arrTitleNumbers中
         */
        string strSelectTitles = "SELECT titles FROM paperInformation WHERE paperId=" + paperId;
        DataSet dsTitles = SqlHelper.FillDataSet(strSelectTitles);

        string strTitles = "";
        if (dsTitles.Tables[0].Rows.Count > 0)
            strTitles = dsTitles.Tables[0].Rows[0][0].ToString();

        int modifyIndex = -1;
        string[] arrTitles = strTitles.Split(';');
        int[] arrTitleNumbers = null;
        for (int i = 0; i < arrTitles.Length;i++ )
        {
            string[] arrTitleDetails = arrTitles[i].Split(':');
            if (arrTitleDetails[0].Equals(newPaperTitleNumber.TitleType))
            {
                modifyIndex = i;
                string[] strTitleNumbers = arrTitleDetails[1].Split(',');
                arrTitleNumbers = new int[strTitleNumbers.Length];
                for (int j = 0; j < strTitleNumbers.Length; j++)
                {
                    arrTitleNumbers[j] = int.Parse(strTitleNumbers[j]);
                }
                break;
            }
        }

        string strNewTitles = "";

        int[] newIds = ArrayHelper.GetRandom(arrSubjectIds, newPaperTitleNumber.TitleNumber, arrTitleNumbers);
        if (modifyIndex != -1)
        {
            for (int i = 0; i < newIds.Length; i++)
            {
                arrTitles[modifyIndex] += "," + newIds[i];
            }

            for (int i = 0; i < arrTitles.Length; i++)
            {
                strNewTitles += arrTitles[i] + ";";
            }

            strNewTitles = strNewTitles.Substring(0, strNewTitles.Length - 1);//去除最后一个;号
        }
        else
        {
            for (int i = 0; i < arrTitles.Length; i++)
            {
                strNewTitles += arrTitles[i];
            }

            if (newIds.Length>0)
                strNewTitles += ";" + newPaperTitleNumber.TitleType + ":";

            for (int i = 0; i < newIds.Length; i++)
            {
                strNewTitles += newIds[i] + ",";
            }
            
            strNewTitles = strNewTitles.Substring(0, strNewTitles.Length-1);//去除最后一个，号

            if (strNewTitles.StartsWith(";"))//如果以；开头，去除掉；
                strNewTitles = strNewTitles.Substring(1, strNewTitles.Length-1);

        }

        string strUpdateTitles = "UPDATE paperInformation SET titles='" + strNewTitles + "' WHERE paperId=" + paperId;
        SqlHelper.ExecuteNonQuery(strUpdateTitles);
    }
}
