﻿using System;
using System.Configuration;
using core.BusinessObject;
using System.Data;
using System.Data.SqlClient;
using System.Collections;

/// <summary>
/// PaperLogicDataAccess 的摘要说明
/// </summary>
/// 
namespace core.DataAccessLayer
{
    public class PaperLogicDataAccess
    {
        private static readonly string _connectionString = ConfigurationManager.AppSettings["GlobalConnectionString"];
        private System.Data.DataSet ds_totle = new DataSet();
        private DataSet ds_com = new DataSet();
        private Random random = new Random();
        private System.Collections.ArrayList arr=new System.Collections.ArrayList();
       // private PaperLogicDataAccess paperLogicDataAccess = new PaperLogicDataAccess();
        public PaperLogicDataAccess()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        public System.Collections.ArrayList getlist()
        {
            this.arr.Add(this.ds_totle);
            this.arr.Add(this.ds_com);
            return this.arr;
        }

        //获取用户所需要的题目
        public string getTheme(core.BusinessObject.PaperTitleNum paperTitleNum, PaperHeadInfo paperHeadInfo,ArrayList arr,bool flag)
        {
            this.ds_totle = (DataSet)arr[0];
            this.ds_com = (DataSet)arr[1];
            SqlConnection con = new SqlConnection(_connectionString);
            string str_sql = "select * from subjectStoreRoom where themeID=" +
                paperTitleNum.titleID + "and courseID='" + paperHeadInfo.courseID +
                "' and difficultFactor='" + paperTitleNum.difficultFactor +
                "' and courseChapter between " + paperTitleNum.courseChapterFrom +
                " and " + paperTitleNum.courseChapterTo;
            using(con)
            {
                con.Open();
                SqlDataAdapter sqlDataAdapter = new SqlDataAdapter(str_sql, con);
                if (this.ds_totle.Tables.Contains(paperTitleNum.titleType))
                {
                    this.ds_totle.Tables.Remove(paperTitleNum.titleType);
                }
                sqlDataAdapter.Fill(this.ds_totle, paperTitleNum.titleType+"总汇");
            }
            if (this.ds_totle.Tables[paperTitleNum.titleType + "总汇"].Rows.Count < paperTitleNum.titleNumber)
            {
                return "数据库中符合条件的数据仅有" + ds_totle.Tables[paperTitleNum.titleType + "总汇"].Rows.Count + "行，不符合您的数据要求，请重新输入，或者与管理员联系";
            }
            else
            {
                //this.paperLogicDataAccess.
                    this.get_com(ds_totle, paperTitleNum,flag);
            }

            return "试题已经成功获取";
        }

        //将试卷的信息录入数据库中去
        public string setData(string str_sql)
        {
            try
            {
                SqlConnection con = new SqlConnection(_connectionString);
                using (con)
                {
                    con.Open();
                    System.Data.SqlClient.SqlCommand sqlCommand = new SqlCommand(str_sql, con);
                    int count = sqlCommand.ExecuteNonQuery();
                    if (count > 0)
                    {
                        return "已经成功插入";
                    }
                    else
                    {
                        return "插入有误";
                    }
                }
            }
            catch (Exception s)
            {
                return s.Message;
            }
        }

        public string setData(byte[] bytes,string str_sql)
        {
            try
            {
                SqlConnection con = new SqlConnection(_connectionString);
                using (con)
                {
                    con.Open();
                    System.Data.SqlClient.SqlCommand sqlCommand = new SqlCommand(str_sql, con);
                    SqlParameter spFile = new SqlParameter("@file", SqlDbType.Image);
                    spFile.Value = bytes;
                    sqlCommand.Parameters.Add(spFile);
                    int count = sqlCommand.ExecuteNonQuery();
                    if (count > 0)
                    {
                        return "已经成功插入";
                    }
                    else
                    {
                        return "插入有误";
                    }
                }
            }
            catch (Exception s)
            {
                return s.Message;
            }
        }


        //在ds中用随机函数来随机抽取符合条件的题目，然后再存放在ds中
        public void get_com(DataSet ds,PaperTitleNum paperTitleNum,bool flag)
        {
            for (int i = 0; i < paperTitleNum.titleNumber; i++)
            {
                int number = this.random.Next(0, ds.Tables[paperTitleNum.titleType + "总汇"].Rows.Count);
                i=generateTable(ds, paperTitleNum,number,i,flag);
                    //this.paperLogicDataAccess.
                    
            }
        }

        //创建该函数，是为了生成相应的表，并将数据存放到相应的表中去
        public int generateTable(DataSet ds, PaperTitleNum paperTitleNum,int num,int i,bool flag)
        {
            if (i == 0 && flag==true)
            {
                System.Data.DataTable dt = new DataTable(paperTitleNum.titleType);
                dt.Columns.Add("subjectID", typeof(int));
                dt.Columns.Add("courseID", typeof(string));//courseID
                dt.Columns.Add("themeID", typeof(int));//themeID
                dt.Columns.Add("subjectContent", typeof(string));//subjectContent
                dt.Columns.Add("subjectAnswer", typeof(string));//subjectAnswer
                dt.Columns.Add("courseChapter", typeof(string));//courseChapter
                dt.Columns.Add("difficultFactor", typeof(string));//difficultFactor
                dt.PrimaryKey = new DataColumn[] { dt.Columns["subjectID"] };//subjectID

                DataRow dr = dt.NewRow();
                this.setEvaluate(dr, num, ds, paperTitleNum);
                DataRow dr1 = dt.Rows.Find(dr["subjectID"].ToString());
                if (dr1 != null)
                {
                    i--;
                }
                else
                {
                    dt.Rows.Add(dr);

                    //this.paperLogicDataAccess.
                    ds_com.Tables.Add(dt);
                }
            }
            else
            {
                DataRow dr=this.ds_com.Tables[paperTitleNum.titleType].NewRow();
                this.setEvaluate(dr, num, ds, paperTitleNum);
                DataRow dr1 = this.ds_com.Tables[paperTitleNum.titleType].Rows.Find(dr["subjectID"].ToString());
                if (dr1 != null)
                {
                    i--;
                }
                else
                {
                    this.ds_com.Tables[paperTitleNum.titleType].Rows.Add(dr);
                }
            }
            return i;

        }

        //给生成的表进行赋值
        public DataRow setEvaluate(DataRow dr, int num, DataSet ds, PaperTitleNum paperTitleNum)
        {
            dr["subjectID"] = ds.Tables[paperTitleNum.titleType + "总汇"].Rows[num]["subjectID"];
            dr["courseID"] = ds.Tables[paperTitleNum.titleType + "总汇"].Rows[num]["courseID"];
            dr["themeID"] = ds.Tables[paperTitleNum.titleType + "总汇"].Rows[num]["themeID"];
            dr["subjectContent"] = ds.Tables[paperTitleNum.titleType + "总汇"].Rows[num]["subjectContent"];
            dr["subjectAnswer"] = ds.Tables[paperTitleNum.titleType + "总汇"].Rows[num]["subjectAnswer"];
            dr["courseChapter"] = ds.Tables[paperTitleNum.titleType + "总汇"].Rows[num]["courseChapter"];
            dr["difficultFactor"] = ds.Tables[paperTitleNum.titleType + "总汇"].Rows[num]["difficultFactor"];
            return dr;
        }

        //将试卷标头中的信息转换成id，使在以后的使用中比较方便
        public static PaperHeadInfo getID(PaperHeadInfo paperHeadInfo)
        {
            SqlConnection con = new SqlConnection(_connectionString);

            //获取教师的编号
            string str_sql = "select teacherID from teacher where teacherName='" + paperHeadInfo.teacherName + "'";
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = str_sql;

            using (con)
            {
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    paperHeadInfo.teacherID = reader["teacherID"].ToString();
                }
                reader.Close();
            }

            str_sql = "select courseID from course where courseName='" + paperHeadInfo.courseName + "'";
            con = new SqlConnection(_connectionString);
            cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = str_sql;
            using (con)
            {
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    paperHeadInfo.courseID = reader["courseID"].ToString();
                }
                reader.Close();
            }

            return paperHeadInfo;
        }

        //将试卷的题型换成题型编号
        public static PaperTitleNum getThemeTypeID(PaperTitleNum paperTitleNum)
        {

            SqlConnection con = new SqlConnection(_connectionString);

            //获取教师的编号
            string str_sql = "select themeID from theme where themeType='" + paperTitleNum.titleType + "'";
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = con;
            cmd.CommandText = str_sql;

            using (con)
            {
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    paperTitleNum.titleID = (int)reader["themeID"];
                }
                reader.Close();
            }

            return paperTitleNum;
        }


        internal static string getTheme(PaperTitleNum paperTitleNum)
        {
            throw new Exception("The method or operation is not implemented.");
        }
    }
}
