﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Paper.BusinessLogicLayer;
using Paper.BusinessObject;

public partial class Data_TeacherInfo_ClassesInfo : System.Web.UI.Page
{
    public string JSON = "";
    private ClassesManager classesManager;

    protected void Page_Load(object sender, EventArgs e)
    {
        string method = Request.Params["cmd"];
        if ("List".Equals(method))
        {
            GetAllData();
        }
        else if ("Save".Equals(method))
        {
            Insert();
        }
        else if ("Update".Equals(method))
        {
            Update();
        }
        else if ("Remove".Equals(method))
        {
            Delete();
        }
    }

    public void GetAllData()
    {
        string limits = Request.Params["limit"];
        string starts = Request.Params["start"];

        if (limits != null && starts != null)
        {
            int limit = int.Parse(limits);
            int start = int.Parse(starts);
            JSON = GetClassesManager().SearchPaging(start, limit);
        }
        else
        {
            JSON = "{success:false}";
        }
    }

    public void Insert()
    {
        Classes cla = new Classes();
        cla.SpecialtyID = Request.Form["SpecialtyID"].ToString().Trim();
        cla.ClassID = Request.Form["ClassID"].ToString().Trim();
        cla.ClassName = Request.Form["ClassName"].ToString().Trim();
        cla.ClassNum = int.Parse(Request.Form["ClassNum"].ToString().Trim());
        cla.YearOfGrade = Request.Form["YearOfGrade"].ToString().Trim();
        cla.DepartmentID = Request.Form["DepartmentID"].ToString().Trim();

        int count = GetClassesManager().Insert(cla);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Update()
    {
        Classes cla = new Classes();
        cla.SpecialtyID = Request.Form["SpecialtyID"];
        cla.ClassID = Request.Form["ClassID"];
        cla.ClassName = Request.Form["ClassName"];
        cla.ClassNum = int.Parse(Request.Form["ClassNum"]);
        cla.YearOfGrade = Request.Form["YearOfGrade"];
        cla.DepartmentID = Request.Form["DepartmentID"];
        cla.Id = int.Parse(Request.Form["Id"].ToString().Trim());

        int count = GetClassesManager().Update(cla);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Delete()
    {
        string deleteIdsStr = Request.Form["deleteIds"];

        if (deleteIdsStr != null)
        {
            string[] deleteIds = deleteIdsStr.Split(',');

            foreach (string deleteId in deleteIds)
            {
                try
                {
                    int count = GetClassesManager().Delete(deleteId);
                }
                catch (Exception)
                {
                    JSON = "{success:'false'}";
                }

            }
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }
    }

    private ClassesManager GetClassesManager()
    {
        if (classesManager == null)
        {
            classesManager = new ClassesManager();
        }
        return classesManager;
    }
}
