﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Paper.BusinessLogicLayer;
using Paper.BusinessObject;

public partial class Data_TeacherInfo_CourseInfo : System.Web.UI.Page
{
    public string JSON = "";
    private CourseManager courseManager;

    protected void Page_Load(object sender, EventArgs e)
    {
        string method = Request.Params["cmd"];
        if ("List".Equals(method))
        {
            GetAllData();
        }
        else if ("Save".Equals(method))
        {
            Insert();
        }
        else if ("Update".Equals(method))
        {
            Update();
        }
        else if ("Remove".Equals(method))
        {
            Delete();
        }
    }

    public void GetAllData()
    {
        string limits = Request.Params["limit"];
        string starts = Request.Params["start"];

        if (limits != null && starts != null)
        {
            int limit = int.Parse(limits);
            int start = int.Parse(starts);
            JSON = GetCourseManager().SearchPaging(start, limit);
        }
        else
        {
            JSON = "{success:false}";
        }
    }

    public void Insert()
    {
        Course course = new Course();
        course.DepartmentID = Request.Form["DepartmentID"];
        course.SpecialtyID = Request.Form["SpecialtyID"];
        course.CourseID = Request.Form["CourseID"];
        course.CourseName = Request.Form["CourseName"];
        course.CourseType = Request.Form["CourseType"];
        course.Remark = Request.Form["Remark"];

        int count = GetCourseManager().Insert(course);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Update()
    {
        Course course = new Course();
        course.DepartmentID = Request.Form["DepartmentID"];
        course.SpecialtyID = Request.Form["SpecialtyID"];
        course.CourseID = Request.Form["CourseID"];
        course.CourseName = Request.Form["CourseName"];
        course.CourseType = Request.Form["CourseType"];
        course.Remark = Request.Form["Remark"];
        course.Id = int.Parse(Request.Form["Id"].ToString().Trim());

        int count = GetCourseManager().Update(course);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Delete()
    {
        string deleteIdsStr = Request.Form["deleteIds"];

        if (deleteIdsStr != null)
        {
            string[] deleteIds = deleteIdsStr.Split(',');

            foreach (string deleteId in deleteIds)
            {
                try
                {
                    int count = GetCourseManager().Delete(deleteId);
                }
                catch (Exception)
                {
                    JSON = "{success:'false'}";
                }

            }
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }
    }

    private CourseManager GetCourseManager()
    {
        if (courseManager == null)
        {
            courseManager = new CourseManager();
        }
        return courseManager;
    }
}
