﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Paper.BusinessLogicLayer;
using Paper.BusinessObject;

public partial class Data_TeacherInfo_DepartmentInfo : System.Web.UI.Page
{
    public string JSON = "";
    private DepartmentManager departmentManager;

    protected void Page_Load(object sender, EventArgs e)
    {
        string method = Request.Params["cmd"];
        if ("List".Equals(method))
        {
            GetAllData();
        }
        else if ("Save".Equals(method))
        {
            Insert();
        }
        else if ("Update".Equals(method))
        {
            Update();
        }
        else if ("Remove".Equals(method))
        {
            Delete();
        }
    }

    public void GetAllData()
    {
        string limits = Request.Params["limit"];
        string starts = Request.Params["start"];

        if (limits != null && starts != null)
        {
            int limit = int.Parse(limits);
            int start = int.Parse(starts);
            JSON = GetDepartmentManager().SearchPaging(start, limit);
        }
        else
        {
            JSON = "{success:false}";
        }
    }

    public void Insert()
    {
        Department department = new Department();
        department.DepartmentID = Request.Form["DepartmentID"];
        department.DepartmentName = Request.Form["DepartmentName"];
        department.BelongToAcademy = Request.Form["BelongToAcademy"];
        department.FoundDepartmentTime = DateTime.Parse(Request.Form["FoundDepartmentTime"]);
        department.BearingOfCultivate = Request.Form["BearingOfCultivate"];

        int count = GetDepartmentManager().Insert(department);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Update()
    {
        Department department = new Department();
        department.DepartmentID = Request.Form["DepartmentID"];
        department.DepartmentName = Request.Form["DepartmentName"];
        department.BelongToAcademy = Request.Form["BelongToAcademy"];
        department.FoundDepartmentTime = DateTime.Parse(Request.Form["FoundDepartmentTime"]);
        department.BearingOfCultivate = Request.Form["BearingOfCultivate"];
        department.Id = int.Parse(Request.Form["Id"]);

        int count = GetDepartmentManager().Update(department);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Delete()
    {
        string deleteIdsStr = Request.Form["deleteIds"];

        if (deleteIdsStr != null)
        {
            string[] deleteIds = deleteIdsStr.Split(',');

            foreach (string deleteId in deleteIds)
            {
                try
                {
                    int count = GetDepartmentManager().Delete(deleteId);
                }
                catch (Exception)
                {
                    JSON = "{success:'false'}";
                }

            }
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }
    }

    private DepartmentManager GetDepartmentManager()
    {
        if (departmentManager == null)
        {
            departmentManager = new DepartmentManager();
        }
        return departmentManager;
    }
}
