﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Paper.BusinessLogicLayer;
using Paper.BusinessObject;

public partial class Data_TeacherInfo_SpecialtyInfo : System.Web.UI.Page
{
    public string JSON = "";
    private SpecialtyManager specialtyManager;

    protected void Page_Load(object sender, EventArgs e)
    {
        string method = Request.Params["cmd"];
        if ("List".Equals(method))
        {
            GetAllData();
        }
        else if ("Save".Equals(method))
        {
            Insert();
        }
        else if ("Update".Equals(method))
        {
            Update();
        }
        else if ("Remove".Equals(method))
        {
            Delete();
        }
    }

    public void GetAllData()
    {
        string limits = Request.Params["limit"];
        string starts = Request.Params["start"];

        if (limits != null && starts != null)
        {
            int limit = int.Parse(limits);
            int start = int.Parse(starts);
            JSON = GetSpecialtyManager().SearchPaging(start, limit);
        }
        else
        {
            JSON = "{success:false}";
        }
    }

    public void Insert()
    {
        Specialty specialty = new Specialty();
        specialty.SpecialtyID = Request.Form["specialtyID"];
        specialty.SpecialtyName = Request.Form["specialtyName"];
        specialty.LengthOfSchooling = Request.Form["lengthOfSchooling"];
        specialty.CompulsoryCreditHour = int.Parse(Request.Form["compulsoryCreditHour"]);
        specialty.SelectCreditHour = int.Parse(Request.Form["selectCreditHour"]);
        specialty.MinCreditHour = int.Parse(Request.Form["minCreditHour"]);
        specialty.DepartmentID = Request.Form["departmentID"];

        int count = GetSpecialtyManager().Insert(specialty);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Update()
    {
        Specialty specialty = new Specialty();
        specialty.SpecialtyID = Request.Form["specialtyID"];
        specialty.SpecialtyName = Request.Form["specialtyName"];
        specialty.LengthOfSchooling = Request.Form["lengthOfSchooling"];
        specialty.CompulsoryCreditHour = int.Parse(Request.Form["compulsoryCreditHour"]);
        specialty.SelectCreditHour = int.Parse(Request.Form["selectCreditHour"]);
        specialty.MinCreditHour = int.Parse(Request.Form["minCreditHour"]);
        specialty.DepartmentID = Request.Form["departmentID"];
        specialty.Id = int.Parse(Request.Form["Id"].ToString().Trim());

        int count = GetSpecialtyManager().Update(specialty);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Delete()
    {
        string deleteIdsStr = Request.Form["deleteIds"];

        if (deleteIdsStr != null)
        {
            string[] deleteIds = deleteIdsStr.Split(',');

            foreach (string deleteId in deleteIds)
            {
                try
                {
                    int count = GetSpecialtyManager().Delete(deleteId);
                }
                catch (Exception)
                {
                    JSON = "{success:'false'}";
                }

            }
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }
    }

    private SpecialtyManager GetSpecialtyManager()
    {
        if (specialtyManager == null)
        {
            specialtyManager = new SpecialtyManager();
        }
        return specialtyManager;
    }
}
