﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Paper.BusinessLogicLayer;
using Paper.BusinessObject;

public partial class Data_TeacherInfo_TeacherInfo : System.Web.UI.Page
{
    public string JSON = "";
    private TeacherManager teacherManager;

    protected void Page_Load(object sender, EventArgs e)
    {
        string method = Request.Params["cmd"];
        if ("List".Equals(method))
        {
            GetAllData();
        }
        else if ("Save".Equals(method))
        {
            Insert();
        }
        else if ("Update".Equals(method))
        {
            Update();
        }
        else if ("Remove".Equals(method))
        {
            Delete();
        }
    }

    public void GetAllData()
    {
        string limits = Request.Params["limit"];
        string starts = Request.Params["start"];

        if (limits != null && starts != null)
        {
            int limit = int.Parse(limits);
            int start = int.Parse(starts);
            JSON = GetTeacherManager().SearchPaging(start, limit);
        }
        else
        {
            JSON = "{success:false}";
        }
    }

    public void Insert()
    {
        Teacher teacher = new Teacher();
        teacher.TeacherID = Request.Form["teacherID"];
        teacher.TeacherName = Request.Form["teacherName"];
        teacher.TeacherSex = Request.Form["teacherSex"];
        teacher.PostName = Request.Form["postName"];
        teacher.PID = Request.Form["PID"];
        teacher.TeacherPassword = Request.Form["teacherPassword"];

        int count = GetTeacherManager().Insert(teacher);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Update()
    {
        Teacher teacher = new Teacher();
        teacher.TeacherID = Request.Form["teacherID"];
        teacher.TeacherName = Request.Form["teacherName"];
        teacher.TeacherSex = Request.Form["teacherSex"];
        teacher.PostName = Request.Form["postName"];
        teacher.PID = Request.Form["PID"];
        teacher.TeacherPassword = Request.Form["teacherPassword"];
        teacher.Id = int.Parse(Request.Form["Id"].ToString().Trim());

        int count = GetTeacherManager().Update(teacher);
        
        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }
   
    }

    public void Delete()
    {
        string teacherIdsStr = Request.Form["deleteIds"];

        if (teacherIdsStr != null)
        {
            string[] teacherIds = teacherIdsStr.Split(',');

            foreach (string teacherId in teacherIds)
            {
                try
                {
                    int count = GetTeacherManager().Delete(teacherId);
                }
                catch (Exception)
                {
                    JSON = "{success:'false'}";
                }

            }
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }
    }

    private TeacherManager GetTeacherManager()
    {
        if (teacherManager == null)
        {
            teacherManager = new TeacherManager();
        }
        return teacherManager;
    }
}
