﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using core.BusinessLogicLayer;
using core.BusinessObject;

public partial class Data_Core_CreatePaper : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string method = Request.Params["cmd"].ToString().Trim();
        if ("BeginPaper".Equals(method))
        {
            BeginPaper();
        }
        else if ("AddTheme".Equals(method))
        {
            AddTitleNumber();
        }
        else if ("List".Equals(method))
        {
            ShowPaperDetails();
        }
        else if ("CreatePaper".Equals(method))
        {
            CreatePaper();
        }
    }

    protected void BeginPaper()
    {
        try
        {
            //从界面中将试卷编号、教师名称、课程名称、适考专业、考试类型和出卷时间这些获取出来
            int paperID = int.Parse(Request.Params["subjectID"].Trim().ToString());
            string teacherId = Request.Params["teacherId"].Trim().ToString();
            string courseId = Request.Params["courseId"].Trim().ToString();
            string suitSpecialty = Request.Params["suitSpecialty"].Trim().ToString();
            string testType = Request.Params["testType"].Trim().ToString();
            string paperTime = Request.Params["createPaperTime"].ToString();

            PaperInformation paperInformation = new PaperInformation();
            paperInformation.PaperID = paperID;
            paperInformation.TeacherID = teacherId;
            paperInformation.CourseID = courseId;
            paperInformation.SuitSpecialty = suitSpecialty;
            paperInformation.TestType = testType;
            paperInformation.PaperTime = paperTime;

            new PaperInformationManager().Insert(paperInformation);

            Response.Clear();
            Response.Write("{success: true}");
            //Response.End();
        }
        catch (Exception e)
        {
            e.ToString();
            Response.Clear();
            Response.Write("{success: false}");
            //Response.End();
        }
    }

    public void AddTitleNumber()
    {
        //建立需要的bean对象，然后进行传值
        try
        {
            PaperTitleNumber paperTitleNumber = new PaperTitleNumber();

            int paperID = int.Parse(Request.Params["subjectID"].Trim().ToString());
            string teacherId = Request.Params["teacherId"].Trim().ToString();
            string themeType = Request.Params["themeType"].Trim().ToString();
            int themeNum = int.Parse(Request.Params["themeNumber"].Trim().ToString());
            string difficultFactor = Request.Params["difficultFactor"].Trim().ToString();
            int courseChapterFrom = int.Parse(Request.Params["courseChapterFrom"].Trim().ToString());
            int courseChapterTo = int.Parse(Request.Params["courseChapterTo"].Trim().ToString());

            string courseId = Request.Params["courseId"].Trim().ToString();

           
            // 将界面中的题型、题量、难易系数、章节从和到这几个参数放到PaperTitleNumber这个bean中去
            paperTitleNumber.PaperID = paperID;
            paperTitleNumber.TeacherID = teacherId;
            paperTitleNumber.TitleType = themeType;
            paperTitleNumber.TitleNumber = themeNum;
            paperTitleNumber.DifficultFactor = difficultFactor;
            paperTitleNumber.CourseChapterFrom = courseChapterFrom;
            paperTitleNumber.CourseChapterTo = courseChapterTo;

            PaperTitleNumberManager ptnManager = new PaperTitleNumberManager();
            ptnManager.AddTitle(paperTitleNumber, courseId, paperID);

            //提示信息
            Response.Clear();
            Response.Write("{success: true}");
        }
        catch (Exception e)
        {
            e.ToString();
            Response.Clear();
            Response.Write("{success: false}");
            //Response.End();
        }
    }

    public void ShowPaperDetails()
    {
        try
        {
            int paperId = int.Parse(Request.Params["paperId"].Trim().ToString());

            string JSON = new SubjectManager().GetTitles(paperId);

            Response.Clear();
            Response.ContentType = "text/xml";
            Response.Write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            Response.Write(JSON);
            //Response.End();
        }
        catch
        { 
        }
    }

    public void CreatePaper()
    {
        try
        {
            PaperHeadInfo paperHeadInfo = new PaperHeadInfo();
            PaperInfo paperInfo = new PaperInfo();

            paperHeadInfo.courseID = Request.Params["subjectID"].Trim().ToString();
            paperHeadInfo.courseName = Request.Params["courseName"].Trim().ToString();
            paperHeadInfo.teacherName = Request.Params["teacherName"].Trim().ToString();

            paperInfo.suitSpecialty = Request.Params["suitSpecialty"].Trim().ToString();
            paperInfo.paperTime = Request.Params["createPaperTime"].Trim().ToString();
            paperInfo.testType = Request.Params["testType"].Trim().ToString();

            List<Subject> questions = new SubjectManager().GetPaper(int.Parse(paperHeadInfo.courseID));

            string pathdoc = Server.MapPath("\\" + "PM2/WordDoc//");
            string pathdot = Server.MapPath("\\" + "PM2/WordDot//");
            WordPages objWordPages = new WordPages(pathdoc, pathdot, paperHeadInfo, paperInfo);
            WordObject objWordObject = objWordPages.makeword(questions);

            if (objWordObject.Wordflag)
            {
                Response.Write("{success:true,QuestionPath:'" + objWordObject.QuestionPath + "',AnswerPath:'" + objWordObject.AnswerPath + "'}");
            }
            else
            {
                Response.Write("{success:false}");
            }

        }
        catch (Exception s)
        {
            Response.Write("<Script language=JavaScript>alert('" + s.Message + "');</Script>");
        }
    }
}
