﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using core.BusinessLogicLayer;
using core.BusinessObject;

public partial class Data_Core_SubjectInfo : System.Web.UI.Page
{
    public string JSON = "";
    private SubjectManager subjectManager;

    protected void Page_Load(object sender, EventArgs e)
    {
        string method = Request.Params["cmd"];
        if ("List".Equals(method))
        {
            JSON = GetAllData();

            Response.Clear();
            Response.ContentType = "text/xml";
            Response.Write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            Response.Write(JSON);
            Response.End();
        }
        else if ("Save".Equals(method))
        {
            Insert();
        }
        else if ("Update".Equals(method))
        {
            Update();
        }
        else if ("Remove".Equals(method))
        {
            Delete();
        }
    }

    public string GetAllData()
    {
        string limits = Request.Params["limit"];
        string starts = Request.Params["start"];

        if (limits != null && starts != null)
        {
            int limit = int.Parse(limits);
            int start = int.Parse(starts);
            return GetSubjectManager().SearchPaging(start, limit);
        }

        return "{success:false}";
    }

    public void Insert()
    {
        Subject subject = new Subject();
        subject.CourseName = Request.Form["courseId"];
        subject.ThemeName = Request.Form["themeType"];
        subject.SubjectContent = Request.Form["subjectContent"];
        subject.SubjectAnswer = Request.Form["subjectAnswer"];
        subject.CourseChapter = Request.Form["courseChapter"];
        subject.DifficultFactor = Request.Form["difficultFactor"];

        int count = GetSubjectManager().Insert(subject);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Update()
    {
        Subject subject = new Subject();
        subject.SubjectID = Request.Form["subjectID"];
        subject.CourseName = Request.Form["courseId"];
        subject.ThemeName = Request.Form["themeType"];
        subject.SubjectContent = Request.Form["subjectContent"];
        subject.SubjectAnswer = Request.Form["subjectAnswer"];
        subject.CourseChapter = Request.Form["courseChapter"];
        subject.DifficultFactor = Request.Form["difficultFactor"];
        subject.Id = int.Parse(Request.Form["Id"].ToString().Trim());

        int count = GetSubjectManager().Update(subject);

        if (count > 0)
        {
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }

    }

    public void Delete()
    {
        string deleteIdsStr = Request.Form["deleteIds"];

        if (deleteIdsStr != null)
        {
            string[] deleteIds = deleteIdsStr.Split(',');

            foreach (string deleteId in deleteIds)
            {
                try
                {
                    Subject temp = new Subject();
                    temp.SubjectID = deleteId;

                    int count = GetSubjectManager().Delete(temp);
                }
                catch (Exception)
                {
                    JSON = "{success:'false'}";
                }

            }
            JSON = "{success:'true'}";
        }
        else
        {
            JSON = "{success:'false'}";
        }
    }

    private SubjectManager GetSubjectManager()
    {
        if (subjectManager == null)
        {
            subjectManager = new SubjectManager();
        }
        return subjectManager;
    }
}
