﻿
ClassesInfoPanel = Ext.extend(Ext.darkness.CrudPanel, {
    id: "ClassesInfoPanelId",
    title: "部门信息管理",
    //width: 400,
	//height: 300,
    //这个是数据源url
    baseUrl: "Data/BaseInfo/ClassesInfo.aspx",
    storeMapping: ["SpecialtyID","ClassID","ClassName","ClassNum","YearOfGrade","DepartmentID","Id"],
	ID: "Id",
                
    createForm: function(){
        var formPanel = new Ext.form.FormPanel({
			plain:true,
			layout:"form",
			defaultType:"textfield",
			labelWidth:75,
            baseCls:"x-plain",
			//锚点布局-
			defaults:{anchor:"95%",msgTarget:"side"},
			buttonAlign:"center",
			bodyStyle:"padding:0 0 0 0",
			items:[{
			        name:"SpecialtyID",
					fieldLabel:"<font color=red>专业编号</font>",
					readOnly:false
			},{
			        name:"ClassID",
					fieldLabel:"<font color=red>班级编号</font>",
					allowBlank:false,
                    blankText:"班级编号不允许为空",
                    regex:/^[\s\S]{1,10}$/,
                    regexText:"班级编号请不要超过10个字符"
			},{        
			        name:"ClassName",
					fieldLabel:"<font color=red>班级名称</font>",
					allowBlank:false,
                    blankText:"班级名称不允许为空",
                    regex:/^[\s\S]{1,10}$/,
                    regexText:"班级名称请不要超过10个字符"
			},{
			        name:"ClassNum",
					fieldLabel:"<font color=red>班级人数</font>"
			},{
			        name:"YearOfGrade",
					fieldLabel:"届次"
			},{
			        name:"DepartmentID",
					fieldLabel:"系部编号"
			},{
			        name: "Id",
			        xtype: "hidden"
			}]
	    });
			
        return formPanel;
    },
    createWin: function(status){
        return this.initWin(380, 300, status);
    },

 
    constructor: function(){
        
        this.sm = new Ext.grid.CheckboxSelectionModel();
        
        this.cm = new Ext.grid.ColumnModel([
            new Ext.grid.RowNumberer(),//获得行号
		    this.sm,{
		        header:"专业编号",
		        dataIndex:"SpecialtyID",
		        tooltip:"专业唯一标识",
		        //可以进行排序
                sortable:true
	        },{
		        header:"班级编号",
		        tooltip:"班级编号",
		        dataIndex:"ClassID",
                sortable:true,
                renderer:function(value)
                {
                    return "<font color=#EE9572>"+value+"</font>";
                }
	        },{
		        header:"班级名称",
		        width:80,
		        tooltip:"班级名称",
		        dataIndex:"ClassName",
                sortable:true
	        },{
		        header:"班级人数",
		        width:220,
		        tooltip:"班级人数",
		        dataIndex:"ClassNum",
		        //可以进行排序
                sortable:true
	        },{
		        header:"届次",
		        width:220,
		        tooltip:"届次",
		        dataIndex:"YearOfGrade",
		        //可以进行排序
                sortable:true
	        },{
		        header:"系部编号",
		        width:220,
		        tooltip:"系部编号",
		        dataIndex:"DepartmentID",
		        //可以进行排序
                sortable:true
	        },{
			    dataIndex: "Id"
			}
	    ]);
     
        ClassesInfoPanel.superclass.constructor.call(this);
        
    }
});
