﻿
CourseInfoPanel = Ext.extend(Ext.darkness.CrudPanel, {
    id: "CourseInfoPanelId",
    title: "课程信息管理",
    //width: 400,
	//height: 300,
    //这个是数据源url
    baseUrl: "Data/BaseInfo/CourseInfo.aspx",
    storeMapping: ["DepartmentID","SpecialtyID","CourseID","CourseName","CourseType","Remark","Id"],
	ID: "Id",

    createForm: function(){
        var formPanel = new Ext.form.FormPanel({
			plain:true,
			layout:"form",
			defaultType:"textfield",
			labelWidth:75,
            baseCls:"x-plain",
			//锚点布局-
			defaults:{anchor:"95%",msgTarget:"side"},
			buttonAlign:"center",
			bodyStyle:"padding:0 0 0 0",
			items:[{
			        name:"DepartmentID",
					fieldLabel:"<font color=red>系部</font>",
					readOnly:false
			},{        
			        name:"SpecialtyID",
					xtype:"combo",
					fieldLabel:"专业",
					//传入后台真实值value field /value
					hiddenName:"SpecialtyID",
					readOnly:true,
					mode:"local",
					displayField:"show",
					valueField:"value",
					triggerAction:"all",
					value:"Java开发",
					store:new Ext.data.SimpleStore({
						fields:["show","value"],
						data:[["Java开发","Java开发"],[".NET开发",".NET开发"]]
					})
			},{
			        name:"CourseID",
					fieldLabel:"<font color=red>课程编号</font>"
			},{
			        name:"CourseName",
					fieldLabel:"<font color=red>课程名称</font>",
					allowBlank:false,
                    blankText:"课程名称不允许为空",
                    regex:/^[\s\S]{1,10}$/,
                    regexText:"课程名称请不要超过10个字符"
			},{
			        name:"CourseType",
					fieldLabel:"类型"
					
			},{   
			        name:"Remark",
					fieldLabel:"备注"
			},{
			        name: "Id",
			       xtype: "hidden"
			}]
	    });
			
        return formPanel;
    },
    createWin: function(status){
        return this.initWin(380, 300, status);
    },

 
    constructor: function(){
        
        this.sm = new Ext.grid.CheckboxSelectionModel();
        
        this.cm = new Ext.grid.ColumnModel([
            new Ext.grid.RowNumberer(),//获得行号
		    this.sm,{
		        header:"系部",
		        dataIndex:"DepartmentID",
		        tooltip:"系部",
		        //可以进行排序
                sortable:true
	        },{
		        header:"专业",
		        tooltip:"专业",
		        dataIndex:"SpecialtyID",
                sortable:true,
                renderer:function(value)
                {
                    return "<font color=#EE9572>"+value+"</font>";
                }
	        },{
		        header:"课程编号",
		        width:80,
		        tooltip:"课程编号",
		        dataIndex:"CourseID",
                sortable:true
	        },{
		        header:"课程名称",
		        width:220,
		        tooltip:"课程名称",
		        dataIndex:"CourseName",
		        //可以进行排序
                sortable:true
	        },{
		        header:"类型",
		        tooltip:"类型",
		        width:130,
		        dataIndex:"CourseType",
                sortable:true,
                renderer:function(value)
                {
                    return "<b>"+value+"</b>";
                }
	        },{
		        header:"备注",
		        width:220,
		        tooltip:"备注",
		        dataIndex:"Remark",
		        //可以进行排序
                sortable:true
	        },{
			    dataIndex: "Id"
			}
	    ]);
     
        CourseInfoPanel.superclass.constructor.call(this);
        
    }
});
