﻿
DepartmentInfoPanel = Ext.extend(Ext.darkness.CrudPanel, {
    id: "DepartmentInfoPanelId",
    title: "部门信息管理",
    //width: 400,
	//height: 300,
    //这个是数据源url
    baseUrl: "Data/BaseInfo/DepartmentInfo.aspx",
    storeMapping: ["DepartmentID","DepartmentName","BelongToAcademy","FoundDepartmentTime","BearingOfCultivate","Id"],
	ID: "Id",
                
    createForm: function(){
        var formPanel = new Ext.form.FormPanel({
			plain:true,
			layout:"form",
			defaultType:"textfield",
			labelWidth:75,
            baseCls:"x-plain",
			//锚点布局-
			defaults:{anchor:"95%",msgTarget:"side"},
			buttonAlign:"center",
			bodyStyle:"padding:0 0 0 0",
			items:[{
			        name:"DepartmentID",
					fieldLabel:"<font color=red>系部编号</font>",
					readOnly:false
			},{
			        name:"DepartmentName",
					fieldLabel:"<font color=red>系部名称</font>",
					allowBlank:false,
                    blankText:"系部名称不允许为空",
                    regex:/^[\s\S]{1,10}$/,
                    regexText:"系部名称请不要超过10个字符"
			},{        
			        name:"BelongToAcademy",
					fieldLabel:"<font color=red>所属学院</font>",
					allowBlank:false,
                    blankText:"所属学院不允许为空",
                    regex:/^[\s\S]{1,10}$/,
                    regexText:"所属学院请不要超过10个字符"
			},{
			        name:"FoundDepartmentTime",
					fieldLabel:"<font color=red>建系时间</font>"
			},{
			        name:"BearingOfCultivate",
					fieldLabel:"人才培养方向"
					
			},{
			        name: "Id",
			        xtype: "hidden"
			}]
	    });
			
        return formPanel;
    },
    createWin: function(status){
        return this.initWin(380, 300, status);
    },

 
    constructor: function(){
        
        this.sm = new Ext.grid.CheckboxSelectionModel();
        
        this.cm = new Ext.grid.ColumnModel([
            new Ext.grid.RowNumberer(),//获得行号
		    this.sm,{
		        header:"系部编号",
		        dataIndex:"DepartmentID",
		        tooltip:"系部唯一标识",
		        //可以进行排序
                sortable:true
	        },{
		        header:"系部名称",
		        tooltip:"系部名称",
		        dataIndex:"DepartmentName",
                sortable:true,
                renderer:function(value)
                {
                    return "<font color=#EE9572>"+value+"</font>";
                }
	        },{
		        header:"所属学院",
		        width:80,
		        tooltip:"所属学院",
		        dataIndex:"BelongToAcademy",
                sortable:true
	        },{
		        header:"建系时间",
		        width:220,
		        tooltip:"建系时间",
		        dataIndex:"FoundDepartmentTime",
		        //可以进行排序
                sortable:true
	        },{
		        header:"人才培养方向",
		        width:220,
		        tooltip:"人才培养方向",
		        dataIndex:"BearingOfCultivate",
		        //可以进行排序
                sortable:true
	        },{
			    dataIndex: "Id"
			}
	    ]);
     
        DepartmentInfoPanel.superclass.constructor.call(this);
        
    }
});
