﻿/**
  * 基本信息管理树
  */
Ext.darkness.BaseInfoManageTree = Ext.extend(Ext.tree.TreePanel,{
    
    root: null,
    
    constructor:function(){
    
        this.root = new Ext.tree.AsyncTreeNode({
            id:"asedadedfged",
            text:"教学管理系统",
             children: [{
                    id: "departmentInfoManager",
                    text: "系部信息管理",
                    iconCls: 'roomicons',
                    leaf: true
                },{
                    id: "teacherInfoManager",
                    text: "教师信息管理",
                    iconCls: 'usericon',
                    leaf: true
                },{
                    id: "classesInfoManager",
                    text: "班级信息管理",
                    iconCls: 'openroomicon',
                    leaf: true
                },{
                    id: "specialtyInfoManager",
                    text: "专业信息管理",
                    iconCls: 'editGif',
                    leaf: true
                },{
                    id: "courseInfoManager",
                    text: "课程信息管理",
                    iconCls: 'homemanage',
                    leaf: true
                }
            ]
        }); 
        
        Ext.darkness.BaseInfoManageTree.superclass.constructor.call(this,{

                //如果超出范围带自动滚动条
                autoScroll:true,
                animate:true,
                root: this.root,
                //默认根目录不显示
                rootVisible:false,
                border:false,
                animate:true,
                lines:true,
                enableDD:true,
                containerScroll:true,
                loader: new Ext.tree.TreeLoader(),
                listeners:{
                    "click":function(node,event) {
                        //叶子节点点击不进入链接
                        if (node.isLeaf()) {
			                // 显示叶子节点菜单
			                event.stopEvent();
				            ALLEvents(node);
		                } else {
		                    //不是叶子节点不触发事件
			                event.stopEvent();
			                //点击时展开
			                node.toggle();
		               }
                        
                    }
                }
        });
    }
});
