﻿
SpecialtyInfoPanel = Ext.extend(Ext.darkness.CrudPanel, {
    id: "SpecialtyInfoPanelId",
    title: "专业信息管理",
    //width: 400,
	//height: 300,
    //这个是数据源url
    baseUrl: "DATA/BaseInfo/SpecialtyInfo.aspx",
    storeMapping: ["specialtyID","specialtyName","lengthOfSchooling",
                   "compulsoryCreditHour","selectCreditHour","minCreditHour","departmentID","Id"],
	ID: "Id",
	store: null,
	
    createForm: function(){
			
        var formPanel = new Ext.form.FormPanel({
			plain:true,
			layout:"form",
			defaultType:"textfield",
			labelWidth:75,
            baseCls:"x-plain",
			//锚点布局-
			defaults:{anchor:"95%",msgTarget:"side"},
			buttonAlign:"center",
			bodyStyle:"padding:0 0 0 0",
			items:[{
			        name:"specialtyID",
					fieldLabel:"<font color=red>专业编号</font>",
					readOnly:false
			},{
			        name:"specialtyName",
					fieldLabel:"<font color=red>专业名称</font>",
					allowBlank:false,
                    blankText:"专业名称不允许为空",
                    regex:/^[\s\S]{1,20}$/,
                    regexText:"专业名称请不要超过20个字符"
			},{        
			        name:"lengthOfSchooling",
					xtype:"combo",
					fieldLabel:"学制",
					//传入后台真实值value field /value
					hiddenName:"lengthOfSchooling",
					readOnly:true,
					mode:"local",
					displayField:"show",
					valueField:"value",
					triggerAction:"all",
					value:"3",
					store:new Ext.data.SimpleStore({
						fields:["show","value"],
						data:[["3","3"],["4","4"]]
					})
			},{
			        name:"compulsoryCreditHour",
					fieldLabel:"<font color=red>必修学分</font>",
					xtype:"combo",
					//传入后台真实值value field /value
					hiddenName:"compulsoryCreditHour",
					readOnly:true,
					mode:"local",
					displayField:"show",
					valueField:"value",
					triggerAction:"all",
					value:"12",
					store:new Ext.data.SimpleStore({
						fields:["show","value"],
						data:[["12","12"],["18","18"]]
					})
			},{
			        name:"selectCreditHour",
					fieldLabel:"<font color=red>选修学分</font>",
					xtype:"combo",
					//传入后台真实值value field /value
					hiddenName:"selectCreditHour",
					readOnly:true,
					mode:"local",
					displayField:"show",
					valueField:"value",
					triggerAction:"all",
					value:"12",
					store:new Ext.data.SimpleStore({
						fields:["show","value"],
						data:[["12","12"],["18","18"]]
					})
			},{
			        name:"minCreditHour",
					fieldLabel:"<font color=red>最低学分</font>",
					xtype:"combo",
					//传入后台真实值value field /value
					hiddenName:"minCreditHour",
					readOnly:true,
					mode:"local",
					displayField:"show",
					valueField:"value",
					triggerAction:"all",
					value:"12",
					store:new Ext.data.SimpleStore({
						fields:["show","value"],
						data:[["120","120"],["130","130"]]
					})
			},{
			        name:"departmentID",
					fieldLabel:"部门编号",
					allowBlank:false,
                    blankText:"部门不允许为空",
					regex:/^[0-9.]{5,18}$/,
                    regexText:"部门编号为5-18位数字组成"
					
			},{
			        name: "Id",
			        xtype: "hidden"
			}]
	    });
			
        return formPanel;
    },
    createWin: function(status){
        return this.initWin(380, 300, status);
    },

 
    constructor: function(){
		
		this.sm = new Ext.grid.CheckboxSelectionModel();
		
        this.cm = new Ext.grid.ColumnModel([
            new Ext.grid.RowNumberer(),//获得行号
		    this.sm,{
		        header:"专业编号",
		        dataIndex:"specialtyID",
		        tooltip:"专业唯一标识",
		        //可以进行排序
                sortable:true
	        },{
		        header:"专业名称",
		        tooltip:"专业名称",
		        dataIndex:"specialtyName",
                sortable:true,
                renderer:function(value)
                {
                    return "<font color=#EE9572>"+value+"</font>";
                }
	        },{
		        header:"学制",
		        width:80,
		        tooltip:"学制",
		        dataIndex:"lengthOfSchooling",
                sortable:true
	        },{
		        header:"必修学分",
		        width:220,
		        tooltip:"必修学分",
		        dataIndex:"compulsoryCreditHour",
		        //可以进行排序
                sortable:true
	        },{
		        header:"选修学分",
		        width:220,
		        tooltip:"选修学分",
		        dataIndex:"selectCreditHour",
		        //可以进行排序
                sortable:true
	        },{
		        header:"最低学分",
		        width:220,
		        tooltip:"最低学分",
		        dataIndex:"minCreditHour",
		        //可以进行排序
                sortable:true
	        },{
		        header:"部门编号",
		        tooltip:"部门编号",
		        width:130,
		        dataIndex:"departmentID",
                sortable:true,
                renderer:function(value)
                {
                    return "<b>"+value+"</b>";
                }
	        },{
			    dataIndex: "Id"
			}
	    ]);
     
        SpecialtyInfoPanel.superclass.constructor.call(this);
        
    }
});
