﻿
TeacherInfoPanel = Ext.extend(Ext.darkness.CrudPanel, {
    id: "TeacherInfoPanelId",
    title: "教师信息管理",
    //width: 400,
	//height: 300,
    //这个是数据源url
    baseUrl: "Data/BaseInfo/TeacherInfo.aspx",
    storeMapping: ["teacherID","teacherName","teacherSex","postName","PID","teacherPassword","Id"],
	ID: "Id",
    
    createForm: function(){
        var formPanel = new Ext.form.FormPanel({
			plain:true,
			layout:"form",
			defaultType:"textfield",
			labelWidth:75,
            baseCls:"x-plain",
			//锚点布局-
			defaults:{anchor:"95%",msgTarget:"side"},
			buttonAlign:"center",
			bodyStyle:"padding:0 0 0 0",
			items:[{
			        name:"teacherID",
					fieldLabel:"<font color=red>教师编号</font>",
					readOnly:false
			},{
			        name:"teacherName",
					fieldLabel:"<font color=red>教师姓名</font>",
					allowBlank:false,
                    blankText:"教师姓名不允许为空",
                    regex:/^[\s\S]{1,10}$/,
                    regexText:"教师姓名请不要超过10个字符"
			},{        
			        name:"teacherSex",
					xtype:"combo",
					fieldLabel:"教师性别",
					//传入后台真实值value field /value
					hiddenName:"teacherSex",
					readOnly:true,
					mode:"local",
					displayField:"show",
					valueField:"value",
					triggerAction:"all",
					value:"男",
					store:new Ext.data.SimpleStore({
						fields:["show","value"],
						data:[["男","男"],["女","女"]]
					})
			},{
			        name:"postName",
					fieldLabel:"<font color=red>职称</font>",
					allowBlank:false,
                    blankText:"职称不允许为空",
                    regex:/^[\s\S]{1,10}$/,
                    regexText:"职称请不要超过10个字符"
			},{
			        name:"PID",
					fieldLabel:"身份证号",
					allowBlank:false,
                    blankText:"身份证号不允许为空",
					regex:/^[0-9.]{15,18}$/,
                    regexText:"身份证号为15-18位数字组成"
					
			},{   
			        name:"teacherPassword",
					fieldLabel:"密码",
					allowBlank:false,
                    blankText:"密码不允许为空",
					regex:/^[0-9.]{6,13}$/,
                    regexText:"密码为6-13位数字组成"
			},{
			        name: "Id",
			        xtype: "hidden"
			}]
	    });
			
        return formPanel;
    },
    createWin: function(status){
        return this.initWin(380, 300, status);
    },

 
    constructor: function(){
        
        this.sm = new Ext.grid.CheckboxSelectionModel();
        
        this.cm = new Ext.grid.ColumnModel([
            new Ext.grid.RowNumberer(),//获得行号
		    this.sm,{
		        header:"教师编号",
		        dataIndex:"teacherID",
		        tooltip:"教师唯一标识",
		        //可以进行排序
                sortable:true
	        },{
		        header:"教师姓名",
		        tooltip:"教师姓名",
		        dataIndex:"teacherName",
                sortable:true,
                renderer:function(value)
                {
                    return "<font color=#EE9572>"+value+"</font>";
                }
	        },{
		        header:"性别",
		        width:80,
		        tooltip:"性别",
		        dataIndex:"teacherSex",
                sortable:true
	        },{
		        header:"职称",
		        width:220,
		        tooltip:"职称",
		        dataIndex:"postName",
		        //可以进行排序
                sortable:true
	        },{
		        header:"身份证号",
		        tooltip:"教师身份证号",
		        width:130,
		        dataIndex:"PID",
                sortable:true,
                renderer:function(value)
                {
                    return "<b>"+value+"</b>";
                }
	        },{
		        header:"密码",
		        width:220,
		        tooltip:"密码",
		        dataIndex:"teacherPassword",
		        //可以进行排序
                sortable:true
	        },{
			    dataIndex: "Id"
			}
	    ]);
     
        TeacherInfoPanel.superclass.constructor.call(this);
        
    }
});
