﻿
PaperInfoPanel = Ext.extend(Ext.form.FormPanel, {
    
    baseInfo: null,
    typeInfo: null,
    paperInfo: null,
    
    
    constructor:function(){
    
        var day = new Date();
        var genSubjectID = day.getMonth() + '' +  day.getDay() + '' 
                            + day.getHours() + '' + day.getMinutes() + '' + day.getSeconds();
        this.baseInfo = new Ext.form.FieldSet({
                layout: 'form',
                xtype: 'fieldset',
                title: '试卷信息',
                autoHeight: true,
                collapsible:true,
                items:[{
                    layout:'column',
                    defaults: {width: 150,labelAlign: 'left'},
                    items: [{
                        columnWidth:.33,
                        layout: 'form',
                        defaultType: 'textfield',
                        items:[
                            new CourseBox({id: 'courseId'}),new TestTypeBox({id: 'testType'})
                        ]
                    },{
                        columnWidth:.33,
                        layout: 'form',
                        defaultType: 'textfield',
                        items:[new TeacherBox({id: 'teacherId'}),new SuitSpecialtyBox({id: 'suitSpecialty'})
                        ]
                    },{
                        columnWidth:.33,
                        layout: 'form',
                        items:[{
                            fieldLabel: '试卷编号',
                            xtype: 'hidden',
                            name: 'subjectID',
                            value: genSubjectID,
                            id: 'subjectID'
                          },{
                            xtype: 'datefield',
                            fieldLabel: '出卷时间',
                            name: 'createPaperTime',
                            id: 'createPaperTime',
                            width: 130
                          },{
                            layout:'column',
                            items: [{
                                columnWidth:.5,
                                layout: 'form',
                                items:[{
                                    text: '开始出卷',
                                    id: 'btnBeginPaper',
                                    xtype: 'button',
                                    handler: function() {
                                        
        //                                var myMsg = new Ext.LoadMask(Ext.getBody(), {
        //                                   msg: "请稍候。。。"
        //                                });
        //                                myMsg.show();
                                        
                                        Ext.Msg.wait("请等候", "数据准备中...");
                                        
                                        Ext.Ajax.request({
                                           url: 'Data/Core/CreatePaper.aspx?cmd=BeginPaper',
                                           success: function() {
                                                // myMsg.hide();
                                                Ext.Msg.alert("完成", "数据准备完毕!");

                                                Ext.getCmp('btnBeginPaper').setDisabled(true); 
                                                Ext.getCmp('btnCancelPaper').setDisabled(false); 
                                                
                                                
                                                Ext.getCmp('subjectID').setDisabled(true);
                                                Ext.getCmp('teacherId').setDisabled(true);
                                                Ext.getCmp('courseId').setDisabled(true);
                                                Ext.getCmp('suitSpecialty').setDisabled(true);
                                                Ext.getCmp('testType').setDisabled(true);
                                                Ext.getCmp('createPaperTime').setDisabled(true);
                                           },
                                           failure: function() {
                                               // myMsg.hide();

                                                Ext.Msg.alert('与服务器通讯失败，如有问题，请与管理员联系！');
                                           },params: { 
                                                     subjectID: Ext.getCmp('subjectID').getValue(),
                                                     teacherId: Ext.getCmp('teacherId').getValue(),
                                                     courseId: Ext.getCmp('courseId').getValue(),
                                                     suitSpecialty: Ext.getCmp('suitSpecialty').getValue(),
                                                     testType: Ext.getCmp('testType').getValue(),
                                                     createPaperTime: Ext.get('createPaperTime').getValue()
                                           }
                                        });
                                    }
                            }]},{
                                columnWidth:.5,
                                layout: 'form',
                                items:[{
                                    text: '取消出卷',
                                    disabled: true,
                                    id: 'btnCancelPaper',
                                    xtype: 'button',
                                    handler: function() {
                                        Ext.getCmp('btnBeginPaper').setDisabled(false); 
                                        Ext.getCmp('btnCancelPaper').setDisabled(true); 
                                        
                                        
                                        Ext.getCmp('subjectID').setDisabled(false);
                                        Ext.getCmp('teacherId').setDisabled(false);
                                        Ext.getCmp('courseId').setDisabled(false);
                                        Ext.getCmp('suitSpecialty').setDisabled(false);
                                        Ext.getCmp('testType').setDisabled(false);
                                        Ext.getCmp('createPaperTime').setDisabled(false);
                                    }
                               }]
                        }]
                        }]
                    }]
                    }
                ]
        });
                    
        this.typeInfo = new Ext.form.FieldSet({
                layout: 'form',
                xtype: 'fieldset',
                title: '题目信息',
                autoHeight: true,
                collapsible:true,
                items:[{
                    layout:'column',
                    defaults: {width: 150,labelAlign: 'left'},
                    items: [{
                        columnWidth:.32,
                        layout: 'form',
                        items:[new ThemeTypeBox({id: 'themeType'}),new ThemeCountBox({
                        id: 'themeNumber',readOnly: false})]
                    },{
                        columnWidth:.32,
                        layout: 'form',
                        defaultType: 'textfield',
                        items:[new CourseChapterFromBox({
                        id: 'courseChapterFrom'}),
                               new CourseChapterToBox({
                        id: 'courseChapterTo'})]
                    },{
                        columnWidth:.36,
                        layout: 'form',
                        defaultType: 'textfield',
                        items:[new DifficultFactorBox({id: 'difficultFactor'}),{
                                xtype:"button",
                                width: 100,
                                text: '添加试题',
                                handler: function() {
                                    Ext.Ajax.request({
                                       url: 'Data/Core/CreatePaper.aspx?cmd=AddTheme',
                                       success: function() {
                                              
                                            var _store = Ext.getCmp('ShowSubjectInfoPanelId').store;
                                            
                                            //Ext.data.Record[]
                                            //var _oldData = _store.getRange(0,_store.getCount()-1);
                                            
                                            _store.load({
                                                params: {
                                                    subjectID: Ext.getCmp('subjectID').getValue(),
                                                    teacherId: Ext.getCmp('teacherId').getValue(),
                                                    themeType: Ext.get('themeType').getValue(),
                                                    themeNumber: Ext.getCmp('themeNumber').getValue(),
                                                    difficultFactor: Ext.get('difficultFactor').getValue(),
                                                    courseChapterFrom: Ext.get('courseChapterFrom').getValue(),
                                                    courseChapterTo: Ext.get('courseChapterTo').getValue(),
                                                    paperId: Ext.getCmp('subjectID').getValue(),
                                                    courseId: Ext.getCmp('courseId').getValue()
                                                }
                                                //,callback: function() {
                                                //    _store.insert(0,_oldData);
                                                //}
                                            });
                                            
                                       },
                                       failure: function() {
                                            alert('failure');
                                       },params: { 
                                             subjectID: Ext.getCmp('subjectID').getValue(),
                                             teacherId: Ext.getCmp('teacherId').getValue(),
                                             themeType: Ext.get('themeType').getValue(),
                                             themeNumber: Ext.getCmp('themeNumber').getValue(),
                                             difficultFactor: Ext.get('difficultFactor').getValue(),
                                             courseChapterFrom: Ext.get('courseChapterFrom').getValue(),
                                             courseChapterTo: Ext.get('courseChapterTo').getValue(),
                                             
                                             paperId: Ext.getCmp('subjectID').getValue(),
                                             courseId: Ext.getCmp('courseId').getValue()
                                       }
                                    });
                                }
                            }
                        ]
                    }]
                }
                ]
        });
        
        this.paperInfo=new Ext.form.FieldSet({
            collapsible:true,
            title:"<font color=red>生成试卷预览</font>",
            //border:true,
            autoWidth:true,
            autoHeight:true,
            items:[ new SubjectInfoPanel({id: 'ShowSubjectInfoPanelId',
                        title: "生成试卷管理",
                        baseUrl: "Data/Core/CreatePaper.aspx",
                        width: 740,height: 280,pageSize:100})]
        });
        
        
    
        Ext.darkness.PaperInfoManageTree.superclass.constructor.call(this,{
            labelAlign: 'right',
            labelWidth: 60,
            title: '出题',
            frame:true,
            width: 650,
            url: 'url',

            items: [this.baseInfo,this.typeInfo,this.paperInfo],
            
            buttons: [{
                text: '生成Word',
                handler: function() {
                    Ext.Msg.wait("请等候", "正在生成试卷...");
                    
                    Ext.Ajax.request({
                       url: 'Data/Core/CreatePaper.aspx?cmd=CreatePaper',
                       success: function(response) {
                         //获取响应的json字符串  
                        var responseArray = Ext.util.JSON.decode(response.responseText);
                       
                         Ext.Msg.alert('成功','试卷生成成功！<br/>请下载：<br/>/t试卷：<a>' + responseArray.QuestionPath 
                                                                          + "</a>答案：<a>" + responseArray.AnswerPath + "</a>");
                       },
                       failure: function() {
                            Ext.Msg.alert('失败','试卷生成失败！');
                       },params: { 
                                 subjectID: Ext.getCmp('subjectID').getValue(),
                                 teacherName: Ext.get('teacherId').getValue(),
                                 courseName: Ext.get('courseId').getValue(),
                                 suitSpecialty: Ext.get('suitSpecialty').getValue(),
                                 testType: Ext.getCmp('testType').getValue(),
                                 createPaperTime: Ext.get('createPaperTime').getValue()
                       }
                    });
                }
            },{
                text: '导入Word',
                handler: function() {
                    //form.getForm().submit();
                }
            }]
        });
    }
    
});