﻿
SubjectInfoPanel = Ext.extend(Ext.darkness.CrudPanel, {
    //id: 'SubjectInfoPanelId',
    title: "试题信息管理",
    //width: 400,
	//height: 300,
    //这个是数据源url
    baseUrl: "Data/Core/SubjectInfo.aspx",
    storeMapping: ["subjectID","courseName","themeName","subjectContent",
                   "subjectAnswer","courseChapter","difficultFactor","Id"],
	ID: "subjectID",
	view: new Ext.grid.GroupingView({
            forceFit:true,
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
    }),
	
    createForm: function(){

        var formPanel = new Ext.form.FormPanel({
			plain:true,
			layout:"form",
			defaultType:"textfield",
			labelWidth:75,
            baseCls:"x-plain",
			//锚点布局-
			defaults:{anchor:"95%",msgTarget:"side"},
			buttonAlign:"center",
			bodyStyle:"padding:0 0 0 0",
			items:[{
			        xtype: 'panel',
			        baseCls:"x-plain",
                    layout:'column',
                    defaults: {width: 150,labelAlign: 'left'},
                    items: [{
                        columnWidth:.5,
                        baseCls:"x-plain",
                        layout: 'form',
                        items:[new CourseBox({id:'courseName'}),new ThemeTypeBox({id:'themeName'})]
                    },{
                        columnWidth:.5,
                        layout: 'form',
                        baseCls:"x-plain",
                        defaultType: 'textfield',
                        items:[new DifficultFactorBox(),{fieldLabel: '章节',id:'courseChapter'}]
                    }]
                },{
			        name:"subjectContent",
					fieldLabel:"试题内容",
					height: 200,
					xtype: 'textarea',
					allowBlank:false,
                    blankText:"试题内容不允许为空"
			},{   
			        name:"subjectAnswer",
					fieldLabel:"试题答案",
					height: 130,
					xtype: 'textarea',
					allowBlank:false,
                    blankText:"试题答案不允许为空"
			},{
			        name: "Id",
			        xtype: 'hidden'
			},{
			        name: "subjectID",
			        xtype: 'hidden'
			}]
	    });
			
        return formPanel;
    },
    createWin: function(status){
        return this.initWin(700, 500, status);
    },

 
    constructor: function(config){
        
        config = config || {};
        this.baseUrl = config.baseUrl || this.baseUrl;
        
        this.store = new Ext.data.GroupingStore({
            id: this.ID,
            url: this.baseUrl + '?cmd=List',//默认的数据源地址，继承时需要提供
			reader:new Ext.data.XmlReader({
			   totalRecords: "results", // The element which contains the total dataset size (optional)
               record: "row",           // The repeated element which contains row information
               id: this.ID 
			}, Ext.data.Record.create(this.storeMapping)),
			sortInfo:{field: 'Id', direction: "ASC"},
            groupField:'themeName'
		});
						
        this.cm = new Ext.grid.ColumnModel([
            new Ext.grid.RowNumberer(),//获得行号
		    this.sm,{
		        header:"试题编号",
		        dataIndex:"subjectID",
		        tooltip:"试题唯一标识",
		        //可以进行排序
                sortable:true
	        },{
		        header:"课程名称",
		        tooltip:"课程名称",
		        dataIndex:"courseName",
                sortable:true,
                renderer:function(value){
                    return "<font color=#EE9572>"+value+"</font>";
                }
	        },{
		        header:"试题类型",
		        width:80,
		        tooltip:"试题类型",
		        dataIndex:"themeName",
                sortable:true
	        },{
		        header:"试题内容",
		        width:220,
		        tooltip:"试题内容",
		        dataIndex:"subjectContent",
		        //可以进行排序
                sortable:true
	        },{
		        header:"试题答案",
		        tooltip:"试题答案",
		        width:130,
		        dataIndex:"subjectAnswer",
                sortable:true,
                renderer:function(value)
                {
                    return "<b>"+value+"</b>";
                }
	        },{
		        header:"课程章节",
		        width:220,
		        tooltip:"课程章节",
		        dataIndex:"courseChapter",
		        //可以进行排序
                sortable:true
	        },{
		        header:"试题难度",
		        width:220,
		        tooltip:"试题难度",
		        dataIndex:"difficultFactor",
		        //可以进行排序
                sortable:true
	        },{
	            header:"标识编号",
			    dataIndex: "Id"
			}
	    ]);
     
        SubjectInfoPanel.superclass.constructor.call(this,config);
        
    }
});
