﻿

Ext.darkness.DynamicCombox = Ext.extend(Ext.form.ComboBox,{
   
    baseUrl: null,
    fieldLabel: null,
    name: null,
    store: null,
    emptyText: null,
    mode: null,
    
    
    constructor: function(config) {
        
        config = config || {};
        
        this.store = this.store || new Ext.data.Store({
            proxy: new Ext.data.HttpProxy({url: this.baseUrl}),
            reader: new Ext.data.ArrayReader({},[
                {name: 'value'},
                {name: 'text'}
            ])
        });
        
        
        Ext.darkness.DynamicCombox.superclass.constructor.call(this,Ext.apply({
            store: this.store,
            fieldLabel: this.fieldLabel,
            name: this.name,
            emptyText: this.emptyText || '请选择',
            mode: this.mode || 'remote',
            triggerAction: 'all',
            valueField: 'value',
            displayField: 'text',
            readOnly: true
            ,listeners :{
                'beforedestroy ': {
                    fn: function() {
                        this.store.addListener("loadexception",function (){
                            this.store.removeAll();
                            this.store.reload();
                        });
                    },
                    scope: this
                }
           }
        }, config));        
    }
});
                        