﻿Ext.namespace('Ext.darkness');

Ext.darkness.DynamicTree = Ext.extend(Ext.tree.TreePanel , {

	menu: null,
    baseUrl: null,
    
	constructor:function(){
		
		this.menu = new Ext.menu.Menu({
			items:[{
				text:'添加',
				handler:this.onInsertNode,
				scope:this
			},{
				text:'删除',
				handler:this.onDeleteNode,
				scope:this
			},{
				text:'修改',
				handler:this.onUpdateNode,
				scope:this
			}]
		}) ;
		
		Ext.darkness.DynamicTree.superclass.constructor.call(this , {
			width:200,
			height:400,
			loader: new Ext.tree.TreeLoader({
				dataUrl: this.baseUrl + '?cmd=getAllData',
				clearOnLoad :false//请求数据时不清除本地数据
			}),
			listeners:{
				'contextmenu':{
					fn:this.onContextmenu,
					scope:this
				},
				"click":function(node,event) {
                    //叶子节点点击不进入链接
                    if (node.isLeaf()) {
			            // 显示叶子节点菜单
			            event.stopEvent();
				        ALLEvents(node);
		            } else {
		                //不是叶子节点不触发事件
			            event.stopEvent();
			            //点击时展开
			            node.toggle();
		           }
                }
			},
			root:new Ext.tree.AsyncTreeNode({
                text: '系部',
				id:'rootId'
            })
		}) ;
	},


	onContextmenu:function(_node , _e){
		this.menu['currentNode'] = _node ;
		
		if(this.menu['currentNode'].id == 'rootId') {//禁用删除操作
			this.menu.items.itemAt(1).setDisabled(true) ;
		} else {
			this.menu.items.itemAt(1).setDisabled(false) ;
		}
		
		this.menu.showAt(_e.getXY()) ;
	},

	onInsertNode:function(){
		Ext.Msg.prompt('请输入新建后的名称' , '新建名称' , this.onInsertNodePrompt , this) ;
	},

	onDeleteNode:function(){
		Ext.Msg.confirm('系统提示' , '你是否确定删除此节点?' , this.onDeleteNodeConfirm , this) ;
	},

	onUpdateNode:function(){
		Ext.Msg.prompt('请输入修改后的名称' , '修改名称' , this.onUpdateNodePrompt , this , false , this.menu['currentNode'].text) ;
	},


	onUpdateNodePrompt:function(_btn , _text){
		if(_btn == 'ok'){
			if(this.menu['currentNode'].text != _text.trim()){//内容被修改了
				this.menu['currentNode'].setText(_text) ;
				Ext.Ajax.request({url: this.baseUrl + '?cmd=update' , params:{id:this.menu['currentNode'].id , text:this.menu['currentNode'].text}}) ;
			}
		}
	},

	onDeleteNodeConfirm:function(_btn){
		if(_btn == 'yes'){
			var _node = this.menu['currentNode'] ;
			Ext.Ajax.request({url:this.baseUrl + '?cmd=delete', params:{parentId:_node.parentNode.id , id:_node.id}}) ;
			_node.remove() ;
		}
	},

	onInsertNodePrompt:function(_btn , _text){
		if(_btn == 'ok'){
			var _parent = this.menu['currentNode'] ;
			_parent.leaf = false ;//当添加子节点的时候，设置当前节点为非叶子节点
			
			var _node = new Ext.tree.AsyncTreeNode({
					text: _text ,
					leaf:true,
					id:Ext.id()
				}) ;
			
			Ext.Ajax.request({url:this.baseUrl + '?cmd=insert' , params:{parentId:_parent.id , id:_node.id , text:_node.text}}) ;
			
			try {
				// 如果isLoaded为false，那么_parent.expand()会再次发送一次请求
				// _node会重复添加
				//if (_parent.isLoaded()) {
					_parent.appendChild(_node) ;
				//}
			} catch (_err) {
			}
			
			_parent.expand() ;
		}
	}
}) ;