using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace Sky.Darkness.Commons.Util
{
    /// <summary>
    /// JsonHelper ժҪ˵
    /// </summary>
    public class JsonHelper
    {
        //ӦJSONsingleInfoԱ
        public string singleInfo = string.Empty;
        protected string _error = string.Empty;
        protected bool _success = true;
        protected long _totalCount = 0;
        protected ArrayList arrData = new ArrayList();
        protected ArrayList arrDataItem = new ArrayList();


        public JsonHelper()
        {
        }

        //ӦJSONsuccessԱ
        public bool Success
        {
            get
            {
                return _success;
            }
            set
            {
                //Ϊtrueerror
                if (Success) _error = string.Empty;
                _success = value;
            }
        }

        //ӦJSONerrorԱ
        public string Error
        {
            get
            {
                return _error;
            }
            set
            {
                //errorԶsuccessΪfalse
                if (value != "") _success = false;
                _error = value;
            }
        }

        public long TotalCount
        {
            get { return _totalCount; }
            set { _totalCount = value; }
        }


        //ãÿһjsonʱִи÷
        public void Reset()
        {
            _success = true;
            _error = string.Empty;
            singleInfo = string.Empty;
            arrData.Clear();
            arrDataItem.Clear();
        }

        public void AddItem(string name, string value)
        {
            arrData.Add("'" + name + "':" + "'" + value + "'");
        }

        public void ItemOk()
        {
            arrData.Add("<BR>");
            TotalCount++;
        }

        //лJSON󣬵õصJSON
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("{");
            sb.Append("totalCount:" + TotalCount.ToString() + ",");
            sb.Append("success:" + _success.ToString().ToLower() + ",");
            sb.Append("error:'" + _error + "',");
            sb.Append("singleInfo:'" + singleInfo + "',");
            sb.Append("data:[");

            int index = 0;
            sb.Append("{");
            if (arrData.Count <= 0)
            {
                sb.Append("}]");
            }
            else
            {
                foreach (string val in arrData)
                {
                    index++;

                    if (val != "<BR>")
                    {
                        sb.Append(val + ",");
                    }
                    else
                    {
                        sb = sb.Replace(",", "", sb.Length - 1, 1);
                        sb.Append("},");
                        if (index < arrData.Count)
                        {
                            sb.Append("{");
                        }
                    }

                }
                sb = sb.Replace(",", "", sb.Length - 1, 1);
                sb.Append("]");
            }

            sb.Append("}");
            return sb.ToString();
        }
    }
}