﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Text;
using System.Collections;
/// <summary>
/// DB 的摘要说明
//5/1aspx </summary>
public class DB
{
	public DB()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}
    //查询专辑表中的所有信息
    public DataTable GetAll()
    {
        SqlHelper helper = new SqlHelper();
        string strsql = "select * from album";
        SqlCommand cmd = new SqlCommand();
        cmd = helper.GetCommand(strsql, null);
        DataTable dt = new DataTable();
        using (SqlDataReader rdr = cmd.ExecuteReader())
        {
            dt.Load(rdr);
        }
        return dt;

    }
    //获取专辑名称
    public DataTable GetAlbumName()
    {
        SqlHelper helper = new SqlHelper();
        string strsql = "select albumID,albumName from album";
        SqlCommand cmd = new SqlCommand();
        cmd = helper.GetCommand(strsql, null);
        DataTable dt = new DataTable();
        using (SqlDataReader rdr = cmd.ExecuteReader())
        {
            dt.Load(rdr);
        }
        return dt;
    }
    public DataTable GetByID(int id)
    {
        SqlHelper helper = new SqlHelper();
        string strsql = "select *from album where albumID=@albumID";
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("@albumID",id)
        };
        SqlCommand cmd = new SqlCommand();
        cmd = helper.GetCommand(strsql, parm);
        DataTable dt = new DataTable();
        using (SqlDataReader rdr = cmd.ExecuteReader())
        {
            dt.Load(rdr);
        }
        return dt;
    }
    public void AddAlbum(string albumName, DateTime albumTime, string logoUrl, string albumDesc)
    {
        SqlHelper helper= new SqlHelper();
        string strsql = "insert into album (albumName,albumTime,logoUrl,albumDesc) values (@name,@time,@logourl,@desc)";
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("@name",albumName ),
            new SqlParameter ("@time",albumTime ),
            new SqlParameter ("@logourl",logoUrl ),
            new SqlParameter ("@desc",albumDesc )
            
        };
        SqlCommand cmd = helper.GetCommand(strsql, parm);
        cmd.ExecuteNonQuery();
        
    }
    public void addimage(int albumID, string imageName, string imageUrl, DateTime imageTime, string imageDesc)
    {
        SqlHelper helper = new SqlHelper();
        string addimage = "insert into image (albumID,imageName,imageUrl,imageTime,imageDesc) values (@albumID,@imageName,@imageUrl,@imageTime,@imageDesc)";
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("@albumID",albumID ),
            new SqlParameter ("@imageName",imageName ),
            new SqlParameter ("@imageUrl",imageUrl ),
            new SqlParameter ("@imageTime",imageTime ),
            new SqlParameter ("@imageDesc",imageDesc )

        };
        SqlCommand cmd = helper.GetCommand(addimage, parm);
        cmd.ExecuteNonQuery();
    }
    public DataTable showImage(int albumID)
    {
        SqlHelper helper = new SqlHelper();
        StringBuilder strsql_show = new StringBuilder();
        strsql_show.Append("select imageID,alb.albumID,alb.albumName,imageName,imageUrl,imageTime,imageDesc");
        strsql_show.Append(" from image as img,album as alb where img.albumID=alb.albumID and img.albumID=@id");
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("@id",albumID )
        };
        SqlCommand cmd = helper.GetCommand(strsql_show.ToString(), parm);
        DataTable dt = new DataTable();
        using (SqlDataReader rdr = cmd.ExecuteReader())
        {
            dt.Load(rdr);
        }
        return dt;
    }
    public DataTable showMoreImage(int id)
    {
        SqlHelper helper = new SqlHelper();
        StringBuilder strsql_show = new StringBuilder();
        strsql_show.Append("select imageID,alb.albumID,alb.albumName,imageName,imageUrl,imageTime,imageDesc");
        strsql_show.Append(" from image as img,album as alb where img.albumID=alb.albumID and img.imageID=@id");
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("@id",id )
        };
        SqlCommand cmd = helper.GetCommand(strsql_show.ToString(), parm);
        DataTable dt = new DataTable();
        using (SqlDataReader rdr = cmd.ExecuteReader())
        {
            dt.Load(rdr);
        }
        return dt;
    }
    public void updateAlbum(int id, string albumDesc, string albumName, DateTime albumTime, string logourl)
    {

        SqlHelper helper = new SqlHelper();
        string strsql = "update album set albumName=@albumName,albumTime=@albumTime,albumDesc=@albumDesc,logoUrl=@logourl where albumID=@albumID";
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("@albumID",id),
            new SqlParameter ("@albumDesc",albumDesc ),
            new SqlParameter ("@albumName",albumName ),
            new SqlParameter ("@logourl",logourl ),
            new SqlParameter ("@albumTime",albumTime )
        };
        SqlCommand cmd = helper.GetCommand(strsql, parm);
        cmd.ExecuteNonQuery();
    }
    public DataTable select_albumMore(int id)
    {
        SqlHelper helper = new SqlHelper();
        string strsql = "select albumName,logoUrl,albumDesc from album where albumID=@albumID";
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("albumID",id )
        };
        SqlCommand cmd = helper.GetCommand(strsql, parm);
        DataTable dt = new DataTable();
        using (SqlDataReader rdr = cmd.ExecuteReader ())
        {
            dt.Load(rdr);
        }
        return dt;
    }
    public DataTable select_Desc(int imageID)
    {
        SqlHelper helper = new SqlHelper();
        string strsql = "select imageDesc from image where imageID=@imageID";
        SqlParameter [] parm=new SqlParameter []
        {
            new SqlParameter ("@imageID",imageID )
        };
        SqlCommand cmd=helper .GetCommand (strsql ,parm );
        DataTable dt=new DataTable ();
        using (SqlDataReader rdr=cmd .ExecuteReader ())
        {
            dt .Load (rdr );
        }
        return dt ;
    }
    public void update(int albumID,string imageDesc,int imageID)
    {
        SqlHelper helper=new SqlHelper ();
        string strsql="update image set albumID=@albumID,imageDesc=@imageDesc where imageID=@imageID";
        SqlParameter [] parm=new SqlParameter []
        {
            new SqlParameter ("albumID",albumID ),
            new SqlParameter ("imageDesc",imageDesc ),
            new SqlParameter ("imageID",imageID )
        };
        SqlCommand cmd=helper .GetCommand (strsql ,parm );
        cmd .ExecuteNonQuery ();
    }
    public void deletemore(ArrayList al)
    {
        SqlHelper helper = new SqlHelper();
        StringBuilder str = new StringBuilder();
        str.Append("delete from image where imageID in (");
        for (int i = 0; i < al.Count; i++)
        {
            str.Append(al[i] + ",");
        }
        string s = str.ToString().Substring(0, str.ToString().Length - 1);
        s += ")";
        SqlCommand cmd = helper.GetCommand(s, null);
        cmd.ExecuteNonQuery();

    }
    public void delete(int albumID)
    {
        SqlHelper helper = new SqlHelper();
        string strsql = "delete from album where albumID=@albumID";
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("albumID",albumID )
        };
        SqlCommand cmd = helper.GetCommand(strsql, parm);
        cmd.ExecuteNonQuery();
    }
    public DataTable select_Cmt(int imageID)
    {
        SqlHelper helper = new SqlHelper();
        string strsql = "select * from Comment where imageID=@imageID";
        SqlParameter[] parm = new SqlParameter[]
        {
            new SqlParameter ("@imageID",imageID )
        };
        SqlCommand cmd = helper.GetCommand(strsql, parm);
        DataTable dt = new DataTable();
        using (SqlDataReader rdr = cmd.ExecuteReader())
        {
            dt.Load(rdr);
        }
        return dt;
    }
   


}
