# Connect with other writers

**Audience**: Writers who would like to contribute to the Fabric documentation.

This topic gives you general advice on how to contribute to one of the many
language translations provided by Fabric.

In this topic, we're going to cover:

* [How to get started](#getting-started)
* [Using Rocket chat](#rocket-chat)
* [Documentation workgroup call](#documentation-workgroup-call)
* [Join a language translation workgroup](#join-a-language-translation-workgroup)
* [Other ways to connect](#other-ways-to-connect)

## Getting started

Before you make a documentation change, you might like to connect with other
people working on the Fabric documentation. Your [Linux Foundation
account](./contributing.html#getting-a-linux-foundation-account) will give you
access to many different resources to help you connect with other contributors
to the documentation.

Once you have a Linux Foundation account, use any or all of the following
mechanisms to connect with others.

## Rocket chat

Hyperledger Fabric uses [Rocket chat](https://chat.hyperledger.org/home) for
interactive discussions on a variety of project topics.

* [Documentation
  channel](https://chat.hyperledger.org/channel/fabric-documentation)

  You'll find beginners and experts sharing information on the Fabric
  documentation. Read the conversation or ask a question on how to get started.


* [International languages channel](https://chat.hyperledger.org/channel/i18n)

  A dedicated channel for general questions on international languages.


* [Japanese
  channel](https://chat.hyperledger.org/channel/fabric-docs-japanese)

  Read, discuss and share ideas related to the Japanese translation.

## Documentation workgroup call

A great place to meet people working on documentation is the Documentation workgroup
call. These are held twice every Friday at a time convenient for both
Eastern and Western hemispheres. The agenda is published in advance, and
there are minutes and recordings of each session.  Find out more on the
[Documentation
wiki](https://wiki.hyperledger.org/display/fabric/Documentation+Working+Group).

## Join a language translation workgroup

Each of the international languages has a welcoming workgroup that you are
encouraged to join. View the [list of international
workgroups](https://wiki.hyperledger.org/display/fabric/International+groups).
See what your favorite workgroup is doing, and get connected with them.
Each workgroup has a list of members and their contact information.

## Other ways to connect

Hyperledger Fabric has many other collaboration mechanisms such as mailing
lists, contributor meetings and maintainer meetings. Find out about these and
more [here](./contributing.html).

Good luck getting started and thanks for your contribution.

<!--- Licensed under Creative Commons Attribution 4.0 International License
https://creativecommons.org/licenses/by/4.0/ -->
