v2.3.0 Release Notes - November 18, 2020
========================================

What's New in Hyperledger Fabric v2.3
-------------------------------------

Hyperledger Fabric v2.3 introduces two new features for improved orderer and peer operations:
* Orderer channel management without a system channel
* Ledger snapshot

See the [What's New documentation](https://hyperledger-fabric.readthedocs.io/en/release-2.3/whatsnew.html) for more details about these new features.

Fixes
-----

All fixes as of v2.2.1 have also been applied to v2.3.0. Additionally the following fixes have been made.

**FAB-18244: orderer - Single node orderer will not start due to inconsistent state**

If using a single node orderer, it was possible to get into an inconsistent state where
a Raft WAL snapshot was taken but an in-flight block at the associated height is not yet written.
This fix resolves the inconsistent state by writing the last block, so that the
single node orderer can start.

**FAB-18192: orderer - Consenter certificate validation fails when MSP is not part of existing configuration**

If adding an organization MSP and a Raft consenter in the same configuration update transaction, validation fails
with error "consensus metadata update for channel config update is invalid" "certificate signed by unknown authority".
This fix adds logic to verify consenters based on the updated set of organization MSP root CAs.

**FAB-18308: peer and orderer - Restore support for MSPs that contain RSA certificate authorities**

While Fabric has never supported RSA for transaction signatures or validation,
certificate authorities included in MSP definitions could be associated with
RSA keys. This ability was inadvertently removed during the development of
release 2.0 and prevented migration of some networks to a 2.x version. With
these changes, version 2.x components will no longer panic when attempting to
initialize MSPs that include CA certificates associated with RSA keys.

**peer and orderer PKCS#11 - Always Finalize the PKCS#11 FindObject Operation**

In certain error paths, a PKCS#11 session was not finalized, leaving the session
in a locked state so that it could not be reused.
This fix finalizes session handles even in error paths, so that the session can be reused
by subsequent calls.

**orderer - Allow tick interval override via orderer.yaml**

If a raft network becomes unstable, sometimes, adjusting the tick
interval duration can be effective to restore it.  However, the tick interval is
stored in the channel configuration, so if the network is not operational,
modifying it is very challenging. This fix adds `Consensus.TickIntervalOverride`
option to orderer.yaml configuration, allowing the channel configuration parameter
to be overridden from the local configuration.

Changes
-------

**Require orderer file ledger location to be set**

The Orderer.FileLedger.Location must now be set. Utilizing the
Orderer.FileLedger.Prefix to generate a new temporary directory
with the specified prefix every time the orderer is restarted
is no longer supported. The orderer will panic if a location is
not provided.

**FAB-18298: orderer - Default values for `General.Cluster.ClientCertificate` and `General.Cluster.ClientPrivateKey`**

If orderer.yaml configuration options
`General.Cluster.ClientCertificate` and `General.Cluster.ClientPrivateKey` are not set,
default them to the server `General.TLS.Certificate` and `General.TLS.PrivateKey` values
when the orderer is not configured to use a separate cluster port.
This change simplifies orderer node configuration by not requiring the client certificates to be explicitly set.

Dependency updates
------------------
Bump Go to 1.14.12.

CouchDB 3.1.1 is now the tested CouchDB version.

Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-2.3/CHANGELOG.md#v230
