v2.3.2 Release Notes - April 23, 2021
=====================================

Improvements
------------

**peer and orderer - Implement legacy name constraints verification for Go 1.15**

These changes reproduce the Go 1.14 name constraint verification in the MSP.
Without these changes, certificate chains that would fail verification in Go 1.14 would
successfully validate in Go 1.15 due to the change mentioned in the [Go 1.15 release notes](https://golang.org/doc/go1.15#commonname).
Specifically, if a signing certificate contains a name constraint, the leaf certificate
does not include SAN extensions, and the leaf's common name looks like a host name,
then the additional verification is performed to ensure deterministic behavior relative
to prior Fabric releases.


Fixes
-----

**FAB-18427: orderer - Report correct reason of stream abort in orderer cluster**

This commit fixes a bug that makes the cluster communication infrastructure
always report an "aborted" reason after a stream terminates.

**FAB-18424: peer - Ledger snapshot request submission with special value "blockNumber 0"**

If a ledger snapshot request is submitted with the special value "blockNumber 0", peer is expected to translate the request to last committed block.
This patch fixes the issue where, it may happen sometimes that the request is translated to block number 1 instead of last committed block.
This leads to the situation where no snapshot gets generated, including any future snapshot requests.
If you have ever used this special value, we encourage you to check the list of pending snapshots requests with `peer snapshot listpending`.
If you notice one or more pending requests that are for the the block numbers lower than the latest committed block, cancel such requests with `peer snapshot cancelrequest` to enable the further snapshot requests to be processed.

**FAB-18304: peer and orderer - Fix leveldb manifest corruption**

This fix updates the version of goleveldb. The prior version of goleveldb had a bug which
could cause manifest corruption in crash scenarios, especially in disk full crash scenarios.
With a corrupted goleveldb database, the peer or orderer would fail to start with error
"panic: Error opening leveldb: leveldb: manifest corrupted".


Dependencies
------------
Fabric v2.3.2 has been tested with the following dependencies:
* Go 1.15.7
* CouchDB v3.1.1


Deprecations (existing)
-----------------------

**FAB-15754: The 'Solo' consensus type is deprecated.**

The 'Solo' consensus type has always been marked non-production and should be in
use only in test environments, however for compatibility it is still available,
but may be removed entirely in a future release.

**FAB-16408: The 'Kafka' consensus type is deprecated.**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred
production consensus type.  There is a documented and tested migration path from
Kafka to Raft, and existing users should migrate to the newer Raft consensus type.
For compatibility with existing deployments, Kafka is still supported,
but may be removed entirely in a future release.
Additionally, the fabric-kafka and fabric-zookeeper docker images are no longer updated, maintained, or published.

**Fabric CouchDB image is deprecated**

v2.2.0 added support for CouchDB 3.1.0 as the recommended and tested version of CouchDB.
If prior versions are utilized, a Warning will appear in peer log.
Note that CouchDB 3.1.0 requires that an admin username and password be set,
while this was optional in CouchDB v2.x. See the
[Fabric CouchDB documentation](https://hyperledger-fabric.readthedocs.io/en/v2.2.0/couchdb_as_state_database.html#couchdb-configuration)
for configuration details.
Also note that CouchDB 3.1.0 default max_document_size is reduced to 8MB. Set a higher value if needed in your environment.
Finally, the fabric-couchdb docker image will not be updated to v3.1.0 and will no longer be updated, maintained, or published.
Users can utilize the official CouchDB docker image maintained by the Apache CouchDB project instead.

**FAB-7559: Support for specifying orderer endpoints at the global level in channel configuration is deprecated.**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of an organization instead.
Configuring orderer endpoints at the organization level accommodates
scenarios where orderers are run by different organizations. Using
this configuration ensures that only the TLS CA certificates of that organization
are used for orderer communications, in contrast to the global channel level endpoints which
would cause an aggregation of all orderer TLS CA certificates across
all orderer organizations to be used for orderer communications.

**FAB-17428: Support for configtxgen flag `--outputAnchorPeersUpdate` is deprecated.**

The `--outputAnchorPeersUpdate` mechanism for updating anchor peers has always had
limitations (for instance, it only works the first time anchor peers are updated).
Instead, anchor peer updates should be performed through the normal config update flow.

**FAB-15406: The fabric-tools docker image is deprecated**

The fabric-tools docker image will not be published in future Fabric releases.
Instead of using the fabric-tools docker image, users should utilize the
published Fabric binaries. The Fabric binaries can be used to make client calls
to Fabric runtime components, regardless of where the Fabric components are running.

**FAB-15317: Block dissemination via gossip is deprecated**

Block dissemination via gossip is deprecated and may be removed in a future release.
Fabric peers can be configured to receive blocks directly from an ordering service
node by using the following configuration:
```
peer.gossip.orgLeader: true
peer.gossip.useLeaderElection: false
peer.gossip.state.enabled: false
```

**FAB-15061: Legacy chaincode lifecycle is deprecated**

The legacy chaincode lifecycle from v1.x is deprecated and will be removed
in a future release. To prepare for the eventual removal, utilize the v2.x
chaincode lifecycle instead, by enabling V2_0 application capability on all
channels, and redeploying all chaincodes using the v2.x lifecycle. The new
chaincode lifecycle provides a more flexible and robust governance model
for chaincodes. For more details see the
[documentation for enabling the new lifecycle](https://hyperledger-fabric.readthedocs.io/en/release-2.2/enable_cc_lifecycle.html).
