CREATE SCHEMA "MAGIC";

CREATE TABLE "MAGIC"."MAGIC_GROUP"
(
 "ID" VARCHAR(32) NOT NULL,
 "GROUP_NAME" VARCHAR(64) NULL,
 "GROUP_TYPE" VARCHAR(1) NULL,
 "GROUP_PATH" VARCHAR(64) NULL,
 "PARENT_ID" VARCHAR(32) NULL,
 "DELETED" CHAR(1) DEFAULT '0'
 NULL
);

CREATE TABLE "MAGIC"."MAGIC_API_INFO_HIS"
(
 "ID" VARCHAR(32) NULL,
 "API_METHOD" VARCHAR(12) NULL,
 "API_PATH" VARCHAR(512) NULL,
 "API_SCRIPT" CLOB NULL,
 "API_PARAMETER" CLOB NULL,
 "API_OPTION" CLOB NULL,
 "API_NAME" VARCHAR(255) NULL,
 "API_GROUP_ID" VARCHAR(32) NULL,
 "API_REQUEST_BODY" CLOB NULL,
 "API_REQUEST_HEADER" CLOB NULL,
 "API_RESPONSE_BODY" CLOB NULL,
 "API_DESCRIPTION" VARCHAR(512) NULL,
 "API_CREATE_TIME" BIGINT NULL,
 "API_UPDATE_TIME" BIGINT NULL
);

CREATE TABLE "MAGIC"."MAGIC_API_INFO"
(
 "ID" VARCHAR(32) NOT NULL,
 "API_METHOD" VARCHAR(12) NULL,
 "API_PATH" VARCHAR(512) NULL,
 "API_SCRIPT" CLOB NULL,
 "API_PARAMETER" CLOB NULL,
 "API_OPTION" CLOB NULL,
 "API_NAME" VARCHAR(255) NULL,
 "API_GROUP_ID" VARCHAR(32) NULL,
 "API_REQUEST_BODY" CLOB NULL,
 "API_REQUEST_HEADER" CLOB NULL,
 "API_RESPONSE_BODY" CLOB NULL,
 "API_DESCRIPTION" VARCHAR(512) NULL,
 "API_CREATE_TIME" BIGINT NULL,
 "API_UPDATE_TIME" BIGINT NULL
);

CREATE TABLE "MAGIC"."MAGIC_FUNCTION"
(
    "ID"                   VARCHAR(32)  NOT NULL,
    "FUNCTION_NAME"        VARCHAR(64)  NULL,
    "FUNCTION_PATH"        VARCHAR(64)  NULL,
    "FUNCTION_PARAMETER" CLOB NULL,
    "FUNCTION_RETURN_TYPE" VARCHAR(32)  NULL,
    "FUNCTION_SCRIPT" CLOB NULL,
    "FUNCTION_GROUP_ID"    VARCHAR(32)  NOT NULL,
    "FUNCTION_DESCRIPTION" VARCHAR(512) NULL,
    "FUNCTION_CREATE_TIME" BIGINT       NULL,
    "FUNCTION_UPDATE_TIME" BIGINT       NULL
);

CREATE TABLE "MAGIC"."MAGIC_FUNCTION_HIS"
(
    "ID"                   VARCHAR(32)  NOT NULL,
    "FUNCTION_NAME"        VARCHAR(64)  NULL,
    "FUNCTION_PATH"        VARCHAR(64)  NULL,
    "FUNCTION_PARAMETER" CLOB NULL,
    "FUNCTION_RETURN_TYPE" VARCHAR(32)  NULL,
    "FUNCTION_SCRIPT" CLOB NULL,
    "FUNCTION_GROUP_ID"    VARCHAR(32)  NOT NULL,
    "FUNCTION_DESCRIPTION" VARCHAR(512) NULL,
    "FUNCTION_CREATE_TIME" BIGINT       NULL,
    "FUNCTION_UPDATE_TIME" BIGINT       NULL
);

ALTER TABLE "MAGIC"."MAGIC_GROUP" ADD CONSTRAINT  PRIMARY KEY("ID") ;

ALTER TABLE "MAGIC"."MAGIC_API_INFO" ADD CONSTRAINT  PRIMARY KEY("ID") ;

ALTER TABLE "MAGIC"."MAGIC_FUNCTION"
    ADD CONSTRAINT PRIMARY KEY ("ID");

CREATE UNIQUE INDEX "PRIMARY" ON "MAGIC"."MAGIC_GROUP" ("ID");

COMMENT ON TABLE "MAGIC"."MAGIC_GROUP" IS 'MagicAPI分组信息表';

COMMENT ON COLUMN "MAGIC"."MAGIC_GROUP"."GROUP_NAME" IS '组名';

COMMENT ON COLUMN "MAGIC"."MAGIC_GROUP"."GROUP_TYPE" IS '组类型，1：接口分组，2：函数分组';

COMMENT ON COLUMN "MAGIC"."MAGIC_GROUP"."GROUP_PATH" IS '分组路径';

COMMENT ON COLUMN "MAGIC"."MAGIC_GROUP"."PARENT_ID" IS '父级ID';

COMMENT ON COLUMN "MAGIC"."MAGIC_GROUP"."DELETED" IS '是否被删除，1：是，0：否';

COMMENT ON TABLE "MAGIC"."MAGIC_API_INFO_HIS" IS 'MagicAPI接口历史记录';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."ID" IS 'api_id';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_METHOD" IS '请求方法';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_PATH" IS '请求路径';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_SCRIPT" IS '接口脚本';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_PARAMETER" IS '接口参数';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_OPTION" IS '接口选项';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_NAME" IS '接口名称';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_GROUP_ID" IS '分组ID';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_REQUEST_BODY" IS '请求体';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_REQUEST_HEADER" IS '请求Header';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_RESPONSE_BODY" IS '输出结果';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_DESCRIPTION" IS '接口描述';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO_HIS"."API_UPDATE_TIME" IS '修改时间';

CREATE UNIQUE INDEX "INDEX26948817097900" ON "MAGIC"."MAGIC_API_INFO" ("ID");

CREATE UNIQUE INDEX "INDEX26948817098000" ON "MAGIC"."MAGIC_FUNCTION" ("ID");

COMMENT ON TABLE "MAGIC"."MAGIC_API_INFO" IS 'MagicAPI接口信息';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_METHOD" IS '请求方法';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_PATH" IS '请求路径';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_SCRIPT" IS '接口脚本';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_PARAMETER" IS '接口参数';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_OPTION" IS '接口选项';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_NAME" IS '接口名称';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_GROUP_ID" IS '分组ID';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_REQUEST_BODY" IS '请求体';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_REQUEST_HEADER" IS '请求Header';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_RESPONSE_BODY" IS '输出结果';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_DESCRIPTION" IS '接口描述';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "MAGIC"."MAGIC_API_INFO"."API_UPDATE_TIME" IS '修改时间';

COMMENT ON TABLE "MAGIC"."MAGIC_FUNCTION" IS 'MagicAPI 函数信息';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."ID" IS '主键';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_NAME" IS '函数名称';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_PATH" IS '函数路径';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_PARAMETER" IS '参数列表';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_RETURN_TYPE" IS '返回值类型';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_SCRIPT" IS '脚本';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_GROUP_ID" IS '所属分组';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_DESCRIPTION" IS '函数描述';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION"."FUNCTION_UPDATE_TIME" IS '修改时间';

COMMENT ON TABLE  "MAGIC"."MAGIC_FUNCTION_HIS" IS 'MagicAPI 函数历史记录';

COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."ID" IS 'function_id';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_NAME" IS '函数名称';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_PATH" IS '函数路径';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_PARAMETER" IS '参数列表';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_RETURN_TYPE" IS '返回值类型';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_SCRIPT" IS '脚本';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_GROUP_ID" IS '所属分组';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_DESCRIPTION" IS '函数描述';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "MAGIC"."MAGIC_FUNCTION_HIS"."FUNCTION_UPDATE_TIME" IS '修改时间';