/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.IndexBlock;
import org.lionsoul.ip2region.Util;

public class DbSearcher {
    public static final int BTREE_ALGORITHM = 1;
    public static final int BINARY_ALGORITHM = 2;
    public static final int MEMORY_ALGORITYM = 3;
    private DbConfig dbConfig = null;
    private RandomAccessFile raf = null;
    private long[] HeaderSip = null;
    private int[] HeaderPtr = null;
    private int headerLength;
    private long firstIndexPtr = 0L;
    private long lastIndexPtr = 0L;
    private int totalIndexBlocks = 0;
    private byte[] dbBinStr = null;

    public DbSearcher(DbConfig dbConfig, String string) throws FileNotFoundException {
        this.dbConfig = dbConfig;
        this.raf = new RandomAccessFile(string, "r");
    }

    public DbSearcher(DbConfig dbConfig, byte[] byArray) {
        this.dbConfig = dbConfig;
        this.dbBinStr = byArray;
        this.firstIndexPtr = Util.getIntLong(byArray, 0);
        this.lastIndexPtr = Util.getIntLong(byArray, 4);
        this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)IndexBlock.getIndexBlockLength()) + 1;
    }

    public DataBlock memorySearch(long l) throws IOException {
        int n;
        int n2;
        int n3 = IndexBlock.getIndexBlockLength();
        if (this.dbBinStr == null) {
            this.dbBinStr = new byte[(int)this.raf.length()];
            this.raf.seek(0L);
            this.raf.readFully(this.dbBinStr, 0, this.dbBinStr.length);
            this.firstIndexPtr = Util.getIntLong(this.dbBinStr, 0);
            this.lastIndexPtr = Util.getIntLong(this.dbBinStr, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)n3) + 1;
        }
        int n4 = 0;
        int n5 = this.totalIndexBlocks;
        long l2 = 0L;
        while (n4 <= n5) {
            n2 = n4 + n5 >> 1;
            n = (int)(this.firstIndexPtr + (long)(n2 * n3));
            long l3 = Util.getIntLong(this.dbBinStr, n);
            if (l < l3) {
                n5 = n2 - 1;
                continue;
            }
            long l4 = Util.getIntLong(this.dbBinStr, n + 4);
            if (l > l4) {
                n4 = n2 + 1;
                continue;
            }
            l2 = Util.getIntLong(this.dbBinStr, n + 8);
            break;
        }
        if (l2 == 0L) {
            return null;
        }
        n2 = (int)(l2 >> 24 & 0xFFL);
        n = (int)(l2 & 0xFFFFFFL);
        int n6 = (int)Util.getIntLong(this.dbBinStr, n);
        String string = new String(this.dbBinStr, n + 4, n2 - 4, "UTF-8");
        return new DataBlock(n6, string, n);
    }

    public DataBlock memorySearch(String string) throws IOException {
        return this.memorySearch(Util.ip2long(string));
    }

    public DataBlock getByIndexPtr(long l) throws IOException {
        this.raf.seek(l);
        byte[] byArray = new byte[12];
        this.raf.readFully(byArray, 0, byArray.length);
        long l2 = Util.getIntLong(byArray, 8);
        int n = (int)(l2 >> 24 & 0xFFL);
        int n2 = (int)(l2 & 0xFFFFFFL);
        this.raf.seek(n2);
        byte[] byArray2 = new byte[n];
        this.raf.readFully(byArray2, 0, byArray2.length);
        int n3 = (int)Util.getIntLong(byArray2, 0);
        String string = new String(byArray2, 4, byArray2.length - 4, "UTF-8");
        return new DataBlock(n3, string, n2);
    }

    public DataBlock btreeSearch(long l) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.HeaderSip == null) {
            this.raf.seek(8L);
            byte[] byArray = new byte[this.dbConfig.getTotalHeaderSize()];
            this.raf.readFully(byArray, 0, byArray.length);
            n5 = byArray.length >> 3;
            n4 = 0;
            this.HeaderSip = new long[n5];
            this.HeaderPtr = new int[n5];
            for (int i = 0; i < byArray.length; i += 8) {
                long l2 = Util.getIntLong(byArray, i);
                long l3 = Util.getIntLong(byArray, i + 4);
                if (l3 == 0L) break;
                this.HeaderSip[n4] = l2;
                this.HeaderPtr[n4] = (int)l3;
                ++n4;
            }
            this.headerLength = n4;
        }
        if (l == this.HeaderSip[0]) {
            return this.getByIndexPtr(this.HeaderPtr[0]);
        }
        if (l == this.HeaderSip[this.headerLength - 1]) {
            return this.getByIndexPtr(this.HeaderPtr[this.headerLength - 1]);
        }
        int n6 = 0;
        n5 = this.headerLength;
        n4 = 0;
        int n7 = 0;
        while (n6 <= n5) {
            n3 = n6 + n5 >> 1;
            if (l == this.HeaderSip[n3]) {
                if (n3 > 0) {
                    n4 = this.HeaderPtr[n3 - 1];
                    n7 = this.HeaderPtr[n3];
                    break;
                }
                n4 = this.HeaderPtr[n3];
                n7 = this.HeaderPtr[n3 + 1];
                break;
            }
            if (l < this.HeaderSip[n3]) {
                if (n3 == 0) {
                    n4 = this.HeaderPtr[n3];
                    n7 = this.HeaderPtr[n3 + 1];
                    break;
                }
                if (l > this.HeaderSip[n3 - 1]) {
                    n4 = this.HeaderPtr[n3 - 1];
                    n7 = this.HeaderPtr[n3];
                    break;
                }
                n5 = n3 - 1;
                continue;
            }
            if (n3 == this.headerLength - 1) {
                n4 = this.HeaderPtr[n3 - 1];
                n7 = this.HeaderPtr[n3];
                break;
            }
            if (l <= this.HeaderSip[n3 + 1]) {
                n4 = this.HeaderPtr[n3];
                n7 = this.HeaderPtr[n3 + 1];
                break;
            }
            n6 = n3 + 1;
        }
        if (n4 == 0) {
            return null;
        }
        n3 = n7 - n4;
        int n8 = IndexBlock.getIndexBlockLength();
        byte[] byArray = new byte[n3 + n8];
        this.raf.seek(n4);
        this.raf.readFully(byArray, 0, byArray.length);
        n6 = 0;
        n5 = n3 / n8;
        long l4 = 0L;
        while (n6 <= n5) {
            n2 = n6 + n5 >> 1;
            n = n2 * n8;
            long l5 = Util.getIntLong(byArray, n);
            if (l < l5) {
                n5 = n2 - 1;
                continue;
            }
            long l6 = Util.getIntLong(byArray, n + 4);
            if (l > l6) {
                n6 = n2 + 1;
                continue;
            }
            l4 = Util.getIntLong(byArray, n + 8);
            break;
        }
        if (l4 == 0L) {
            return null;
        }
        n2 = (int)(l4 >> 24 & 0xFFL);
        n = (int)(l4 & 0xFFFFFFL);
        this.raf.seek(n);
        byte[] byArray2 = new byte[n2];
        this.raf.readFully(byArray2, 0, byArray2.length);
        int n9 = (int)Util.getIntLong(byArray2, 0);
        String string = new String(byArray2, 4, byArray2.length - 4, "UTF-8");
        return new DataBlock(n9, string, n);
    }

    public DataBlock btreeSearch(String string) throws IOException {
        return this.btreeSearch(Util.ip2long(string));
    }

    public DataBlock binarySearch(long l) throws IOException {
        int n;
        int n2 = IndexBlock.getIndexBlockLength();
        if (this.totalIndexBlocks == 0) {
            this.raf.seek(0L);
            byte[] byArray = new byte[8];
            this.raf.readFully(byArray, 0, byArray.length);
            this.firstIndexPtr = Util.getIntLong(byArray, 0);
            this.lastIndexPtr = Util.getIntLong(byArray, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)n2) + 1;
        }
        int n3 = 0;
        int n4 = this.totalIndexBlocks;
        byte[] byArray = new byte[n2];
        long l2 = 0L;
        while (n3 <= n4) {
            n = n3 + n4 >> 1;
            this.raf.seek(this.firstIndexPtr + (long)(n * n2));
            this.raf.readFully(byArray, 0, byArray.length);
            long l3 = Util.getIntLong(byArray, 0);
            if (l < l3) {
                n4 = n - 1;
                continue;
            }
            long l4 = Util.getIntLong(byArray, 4);
            if (l > l4) {
                n3 = n + 1;
                continue;
            }
            l2 = Util.getIntLong(byArray, 8);
            break;
        }
        if (l2 == 0L) {
            return null;
        }
        n = (int)(l2 >> 24 & 0xFFL);
        int n5 = (int)(l2 & 0xFFFFFFL);
        this.raf.seek(n5);
        byte[] byArray2 = new byte[n];
        this.raf.readFully(byArray2, 0, byArray2.length);
        int n6 = (int)Util.getIntLong(byArray2, 0);
        String string = new String(byArray2, 4, byArray2.length - 4, "UTF-8");
        return new DataBlock(n6, string, n5);
    }

    public DataBlock binarySearch(String string) throws IOException {
        return this.binarySearch(Util.ip2long(string));
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public void close() throws IOException {
        this.HeaderSip = null;
        this.HeaderPtr = null;
        this.dbBinStr = null;
        this.raf.close();
    }
}

