/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import org.lionsoul.ip2region.Util;

public class IndexBlock {
    private static int LENGTH = 12;
    private long startIp;
    private long endIp;
    private int dataPtr;
    private int dataLen;

    public IndexBlock(long l, long l2, int n, int n2) {
        this.startIp = l;
        this.endIp = l2;
        this.dataPtr = n;
        this.dataLen = n2;
    }

    public long getStartIp() {
        return this.startIp;
    }

    public IndexBlock setStartIp(long l) {
        this.startIp = l;
        return this;
    }

    public long getEndIp() {
        return this.endIp;
    }

    public IndexBlock setEndIp(long l) {
        this.endIp = l;
        return this;
    }

    public int getDataPtr() {
        return this.dataPtr;
    }

    public IndexBlock setDataPtr(int n) {
        this.dataPtr = n;
        return this;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public IndexBlock setDataLen(int n) {
        this.dataLen = n;
        return this;
    }

    public static int getIndexBlockLength() {
        return LENGTH;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[12];
        Util.writeIntLong(byArray, 0, this.startIp);
        Util.writeIntLong(byArray, 4, this.endIp);
        long l = (long)this.dataPtr | (long)(this.dataLen << 24) & 0xFF000000L;
        Util.writeIntLong(byArray, 8, l);
        return byArray;
    }
}

