/**
 * # 将数据转为数组类型
 * 1 => [1]
 * [1, 2] => [1, 2]
 */
const adapterArray = (value) => {
  return Array.isArray(value) ? value : [value]
}

/**
 * 判断新旧的版本
 * @param {Array} news
 * @param {Array} olds
 * @param {String} key 对比用的key
 */
const diff = (news = [], olds = [], key = 'id') => {
  news = adapterArray(news)
  olds = adapterArray(olds)

  const created = []
  const deleted = []
  const updated = []

  news.forEach((item) => {
    if (!olds.map((i) => i[key]).includes(item[key])) {
      created.push(item)
    } else {
      updated.push(item)
    }
  })

  olds.forEach((item) => {
    if (!news.map((i) => i[key]).includes(item[key])) {
      deleted.push(item)
    }
  })

  return { created, deleted, updated }
}

export default diff
