//
//  AppDelegate.m
//  YBEducation
//
//  Created by IOS1 on 2020/2/21.
//  Copyright © 2020 IOS1. All rights reserved.
//

#import "AppDelegate.h"
#import <Bugly/Bugly.h>
#import "WYTabBarController.h"
#import "ViewController.h"
#import <SharetraceSDK/SharetraceSDK.h>

@interface AppDelegate ()

@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.
    [IQKeyboardManager sharedManager].enable = YES;
    [IQKeyboardManager sharedManager].shouldResignOnTouchOutside = YES;
    [IQKeyboardManager sharedManager].enableAutoToolbar = NO;
    [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"isStartCall"];
    
    [Sharetrace initWithDelegate:self];
    [UIApplication sharedApplication].idleTimerDisabled = YES;
    [[UITabBar appearance] setShadowImage:[[UIImage alloc]init]];

    [[UITabBar appearance] setBackgroundImage:[[UIImage alloc]init]];

   
    [Bugly startWithAppId:BuglyId];
    

    [self thirdPlant];
    
    //推送
    [JPUSHService setupWithOption:launchOptions appKey:JMessageAppKey
                          channel:@"Publish channel"
                 apsForProduction:NO
            advertisingIdentifier:nil];

    if ([[UIApplication sharedApplication] respondsToSelector:@selector(registerUserNotificationSettings:)]) {
        UIUserNotificationSettings *settings = [UIUserNotificationSettings settingsForTypes:UIUserNotificationTypeBadge|UIUserNotificationTypeSound|UIUserNotificationTypeAlert categories:nil];
        [[UIApplication sharedApplication] registerUserNotificationSettings:settings];
    }
    if ([[UIDevice currentDevice].systemVersion floatValue] >= 8.0) {
        //可以添加自定义categories
        [JPUSHService registerForRemoteNotificationTypes:(UIUserNotificationTypeBadge |
                                                          UIUserNotificationTypeSound |
                                                          UIUserNotificationTypeAlert)
                                              categories:nil];
    }

    
    self.window = [[UIWindow alloc]initWithFrame:CGRectMake(0,0,_window_width, _window_height)];
    
    NSDictionary *dic = @{@"id":@"2",@"name":@"一年级"};
    [[NSUserDefaults standardUserDefaults] setObject:dic forKey:@"selectClassIteam"];
  
    WYTabBarController *tabbar = [[WYTabBarController alloc] init];
    self.window.rootViewController = [[UINavigationController alloc] initWithRootViewController:tabbar];
    [self.window makeKeyAndVisible];
    [application setApplicationIconBadgeNumber:0]; //清除角标
    [[UIApplication sharedApplication] cancelAllLocalNotifications];//清除APP所有通知消息
    
    
    return YES;
}

-(void)thirdPlant{
    [ShareSDK registPlatforms:^(SSDKRegister *platformsRegister) {
        [platformsRegister setupQQWithAppId:QQAppId appkey:QQAppKey];
        [platformsRegister setupWeChatWithAppId:WechatAppId appSecret:WechatAppSecret universalLink:WechatUniversalLink];
    }];
    
}

// 应用处于后台，所有下载任务完成调用
- (void)application:(UIApplication *)application handleEventsForBackgroundURLSession:(NSString *)identifier completionHandler:(void (^)(void))completionHandler
{
    _backgroundSessionCompletionHandler = completionHandler;
}


- (void)application:(UIApplication *)application
didReceiveRemoteNotification:(NSDictionary *)userInfo
fetchCompletionHandler:
(void (^)(UIBackgroundFetchResult))completionHandler {
;
   
}
- (void)application:(UIApplication *)application
didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {
     [JPUSHService registerDeviceToken:deviceToken];
}

@end
