<?php
/* versionbeta:name
 * versionbeta:number
 * versionbeta:site
 * versionbeta:pubtime
 */
class tab_meal_table_reserve {
	static $perms;

	//获取表配置参数
	static function get_perms($key) {
		if( empty(self::$perms) ) {
			self::$perms = array(
				"state" => array(tab_other_language::get("待付订金") => 0 , tab_other_language::get("待点菜") => 1 , tab_other_language::get("待上菜") => 2 , tab_other_language::get("用餐结束") => 10 , tab_other_language::get("用餐结束,线下结款") => 11 , tab_other_language::get("用餐中") => 3 , tab_other_language::get("已取消") => -1),
			);
		}
		$arr_return = array();
		if(isset(self::$perms[$key])) $arr_return = self::$perms[$key];
		return $arr_return;
	}

	/* 保存操作
	 * arr_fields : 为字段数据，默认如果包函 id，则为修改，否则为插入
	 * where : 默认为空，用于有时候条件修改
	 */
	static function on_save($arr_fields , $where = '') {
		$arr_return = array("code"=>0,"id"=>0,"msg"=>"");
		if(isset($arr_fields['reserve_id'])) {
			$arr_fields['id'] = $arr_fields['reserve_id'];
			unset($arr_fields['reserve_id']);
		}
		if( isset($arr_fields['id']) ) {
			$arr_return['id'] = (int)$arr_fields['id'];
			unset($arr_fields['id']);
			if( $arr_return['id'] > 0 ) { //大于零，为修改状态
				if( empty($where) ){
					$where = " reserve_id='" . $arr_return['id'] . "'";
				} else {
					$where = "(" . $where . ") and reserve_id='" . $arr_return['id'] . "'";
				}
			}
		}
		$obj_db = cls_obj::db_w();
		if( empty($where) ) {
			if(!isset($arr_fields['reserve_deposit']) || $arr_fields['reserve_deposit']==0) $arr_fields['reserve_state'] = 1;
			//必填项检查
			if(!isset($arr_fields['reserve_table_id']) || empty($arr_fields['reserve_table_id'])) return array("code" => 500 , "msg" => "没有指定预订桌位");
			if(!isset($arr_fields['reserve_pwd']) || empty($arr_fields['reserve_pwd']) ) $arr_fields['reserve_pwd'] = rand(1000,9999);
			//初始默认值
			$arr_fields['reserve_addtime'] = TIME;
			$arr_fields['reserve_number'] = TIME . rand(10000,99999);
			//插入到用户表
			$arr = $obj_db->on_insert(cls_config::DB_PRE."meal_table_reserve",$arr_fields);
			if($arr['code'] == 0) {
				$arr_return['id'] = $obj_db->insert_id();
				//其它非mysql数据库不支持insert_id 时
				if(empty($arr_return['id'])) {
					$where  = "reserve_reserve_id='" . $arr_fields['reserve_reserve_id'] . " and reserve_addtime='" . $arr_fields['reserve_addtime'] . "'";
					$obj_rs = $obj_db->get_one("select reserve_id from ".cls_config::DB_PRE."meal_table_reserve where ".$where);
					if(!empty($obj_rs)) $arr_return['id'] = $obj_rs['reserve_id'];
				}
			} else {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
			$arr_return['number'] = $arr_fields['reserve_number'];
			$arr_return['pwd'] = $arr_fields['reserve_pwd'];
		} else {

			if($arr_return['id'] < 1) {
				$obj_rs = $obj_db->get_one("select reserve_id from ".cls_config::DB_PRE."meal_table_reserve where ".$where);
				if(!empty($obj_rs)) {
					$arr_return['id'] = $obj_rs['reserve_id'];
				} else {
					$arr_return['code'] = 114;
					$arr_return['msg']  = cls_language::get("no_editinfo");//修改信息不在在
					return $arr_return;
				}
				$where = "reserve_id='".$arr_return['id']."'";
			}
			//修改数据表
			$arr = $obj_db->on_update(cls_config::DB_PRE."meal_table_reserve" , $arr_fields , $where);
			if($arr['code'] != 0) {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		}
		return $arr_return;
	}
	/* 删除函数
	 * arr_id : 要删除的 id数组
	 * where : 删除附加条件
	 */
	static function on_delete($arr_id , $where = '') {
		$arr_return = array("code"=>0,"msg"=>"");
		$str_id = fun_format::arr_id($arr_id);
		if( empty($str_id) && empty($where) ){
			$arr_return["code"] = 22;
			$arr_return["msg"]="id".cls_language::get("not_null");
			return $arr_return;
		}
		if( !empty($str_id) ) {
			(is_numeric($str_id)) ? $arr_where[] = "reserve_id='".$str_id."'" : $arr_where[] = "reserve_id in(".$str_id.")";
		}
		$obj_db = cls_obj::db_w();
		$where = implode(" and " , $arr_where);
		$arr_return=$obj_db->on_delete(cls_config::DB_PRE."meal_table_reserve" , $where);
		return $arr_return;
	}
}