<?php
/**
 * 
 */
class tab_other_language {
	static $perms;

	//获取表配置参数
	static function get_perms($key) {
		if( empty(self::$perms) ) {
			self::$perms = array(
			);
		}
		$arr_return = array();
		if(isset(self::$perms[$key])) $arr_return = self::$perms[$key];
		return $arr_return;
	}

	/* 保存操作
	 * arr_fields : 为字段数据，默认如果包函 id，则为修改，否则为插入
	 * where : 默认为空，用于有时候条件修改
	 */
	static function on_save($arr_fields , $where = '') {
		$arr_return = array("code"=>0,"id"=>0,"msg"=>"");
		if(isset($arr_fields['language_id'])) {
			$arr_fields['id'] = $arr_fields['language_id'];
			unset($arr_fields['language_id']);
		}
		if( isset($arr_fields['id']) ) {
			$arr_return['id'] = (int)$arr_fields['id'];
			unset($arr_fields['id']);
			if( $arr_return['id'] > 0 ) { //大于零，为修改状态
				if( empty($where) ){
					$where = " language_id='" . $arr_return['id'] . "'";
				} else {
					$where = "(" . $where . ") and language_id='" . $arr_return['id'] . "'";
				}
			}
		}
		if(isset($arr_fields['language_val'])) {
			$arr_fields['language_val'] = str_replace(" ", "",$arr_fields['language_val']);
			$arr_fields['language_val'] = str_replace("&nbsp;", "",$arr_fields['language_val']);
		}
		$obj_db = cls_obj::db_w();
		if( empty($where) ) {
			//插入到表
			$arr = $obj_db->on_insert(cls_config::DB_PRE."other_language",$arr_fields);
			if($arr['code'] == 0) {
				$arr_return['id'] = $obj_db->insert_id();
				//其它非mysql数据库不支持insert_id 时
				if(empty($arr_return['id'])) {
					$where  = "language_key='" . $arr_fields['language_key'] . " and language_val='".$arr_fields['language_val'] . "'";
					$obj_rs = $obj_db->get_one("select language_id from ".cls_config::DB_PRE."other_language where ".$where);
					if(!empty($obj_rs)) $arr_return['id'] = $obj_rs['language_id'];
				}
			} else {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		} else {

			if($arr_return['id'] < 1) {
				$obj_rs = $obj_db->get_one("select language_id from ".cls_config::DB_PRE."other_language where ".$where);
				if(!empty($obj_rs)) {
					$arr_return['id'] = $obj_rs['language_id'];
				} else {
					$arr_return['code'] = 114;
					$arr_return['msg']  = cls_language::get("no_editinfo");//修改信息不在在
					return $arr_return;
				}
				$where = "language_id='".$arr_return['id']."'";
			}
			//修改数据表
			$arr = $obj_db->on_update(cls_config::DB_PRE."other_language" , $arr_fields , $where);
			if($arr['code'] != 0) {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		}
		if($arr_return['code']==0) self::on_to_file();
		return $arr_return;
	}
	static function on_version_save($arr_fields) {
		$obj_db = cls_obj::db();
		if(!isset($arr_fields['version_language_id']) || empty($arr_fields['version_language_id'])) return array("code" => 500 , "msg" => self::get("没有指定语言所属文字"));
		if(!isset($arr_fields['version_key']) || empty($arr_fields['version_key'])) return array("code" => 500 , "msg" => self::get("没有指定语言版本"));
		$obj_one = cls_obj::db()->get_one("select * from " . cls_config::DB_PRE . "other_language_version where version_language_id='" . $arr_fields['version_language_id'] . "' and version_key='" . $arr_fields['version_key'] . "'");
		$id = 0;
		if(!empty($obj_one)) $arr_fields['version_id'] = $obj_one['version_id'];
		if(isset($arr_fields['version_id']) && !empty($arr_fields['version_id']) ) {
			$arr = $obj_db->on_update(cls_config::DB_PRE."other_language_version" , $arr_fields , "version_id='" . $arr_fields['version_id'] . "'");
		} else {
			$arr = $obj_db->on_insert(cls_config::DB_PRE."other_language_version",$arr_fields);
			if($arr['code'] == 0) $id = $obj_db->insert_id();
		}
		$arr['id'] = $id;
		if($arr['code']==0) self::on_to_file();
		return $arr;
	}
	/* 删除函数
	 * arr_id : 要删除的 id数组
	 * where : 删除附加条件
	 */
	static function on_delete($arr_id , $where = '') {
		$arr_return = array("code"=>0,"msg"=>"");
		$str_id = fun_format::arr_id($arr_id);
		if( empty($str_id) && empty($where) ){
			$arr_return["code"] = 22;
			$arr_return["msg"]="id".cls_language::get("not_null");
			return $arr_return;
		}
		$obj_db = cls_obj::db_w();
		if( !empty($str_id) ) {
			(is_numeric($str_id)) ? $arr_where[] = "language_id='".$str_id."'" : $arr_where[] = "language_id in(".$str_id.")";
		}
		if( !empty($where) ) {
			if(stristr($where , " or ") && substr(trim($where),0,1) != "(") $where = "(" . $where . ")";
			$arr_where[] = $where;
		}
		$where = implode(" and " , $arr_where);
		$arr_return=$obj_db->on_delete(cls_config::DB_PRE."other_language" , $where);
		return $arr_return;
	}
	static function on_to_file() {
		$obj_db = cls_obj::db();
		$arr_list = array();
		$obj_result = $obj_db->select("select * from " . cls_config::DB_PRE . "other_language_version a left join " . cls_config::DB_PRE . "other_language b on a.version_language_id=b.language_id");
		while($obj_rs= $obj_db->fetch_array($obj_result)) {
			if(empty($obj_rs['version_val'])) continue;
			$arr_list[$obj_rs['version_key']][$obj_rs['language_val']] = $obj_rs['version_val'];
		}
		foreach($arr_list as $item=>$key) {
			$val=var_export($key,true);
			$val = '<'.'?php'.chr(10).'return '.$val.";";
			fun_file::file_create(KJ_DIR_DATA."/language/".$item.".php",$val,1);
		}
		return $arr_list;
	}
	static function get($val,$msg1=null,$msg2=null,$msg3=null) {
		$valname = str_replace(" ","",$val);
		$valname = str_replace("&nbsp;","",$valname);
		$str_chinacode = "\x{4e00}-\x{9fa5}";
		if(!preg_match("/[".$str_chinacode."]+/uis",$val)) return $val;

		$type = fun_get::get("app_language");
		if(isset($_GET['app_language'])) {
			cls_obj::get("cls_session")->set("language",$type);
		} else {
			$type = cls_obj::get("cls_session")->get("language");
		}
		if( empty( $type ) ) {
			$type = cls_config::get("language","sys");
		}
		if($type!='cn') {
			if( !isset(self::$perms[$type]) ) {
				self::$perms[$type] = file_exists(KJ_DIR_DATA."/language/".$type.".php") ? include( KJ_DIR_DATA."/language/".$type.".php" ) : array();
			}
			if(isset(self::$perms[$type][$valname])) {
				$val = self::$perms[$type][$valname];
			} else {
				$obj_one = cls_obj::db()->get_one("select * from " . cls_config::DB_PRE . "other_language where language_val='" .$valname . "'");		
				if(empty($obj_one)) {
					$arr_fields = array(
						"language_val"=>$valname,
						"language_beta"=>"语言不存在",
					);
					$arr = self::on_save($arr_fields);
				}
			}
		}
		if($msg1!==null) $val = str_replace("{msg1}",$msg1,$val);
		if($msg2!==null) $val = str_replace("{msg2}",$msg2,$val);
		if($msg3!==null) $val = str_replace("{msg3}",$msg3,$val);
		return $val;	
	}
}