<%
dim UC_ADDRESS
class UC_ADDRESS_CLASS
	
	private oRs,sSQL,sString
	
	private sub class_initialize()
	end sub
	
	public sub init()
		select case ACT
		case "add"
			if SAVE then
				call addSave()
			else
				call add()
			end if
		case "set_default"
			if SAVE then
				call setDefault()
			end if
		case "edit"
			if SAVE then
				call editSave()
			else
				call edit()
			end if
		case "delete"
			call delete()
		case else
			call main()
		end select
	end sub
	
	private sub class_terminate()
	end sub
	
	private function delete()
		V("aid") = OW.int(OW.getForm("post","aid"))
		if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"member_address WHERE aid="& V("aid") &" AND uid="& UID &"") then
			call UC.errorSetting("收货地址不存在") : exit function
		end if
		result = OW.DB.execute("DELETE FROM ["& DB_PRE &"member_address] WHERE aid="& V("aid") &" AND uid="& UID &"")
		UC.actionFinishSuccess     = result
		UC.actionFinishSuccessText = array("删除成功","")
		UC.actionFinishFailText    = array("删除失败","")
		UC.actionFinishRun()
	end function
	
	private function setDefault()
		V("aid") = OW.int(OW.getForm("post","aid"))
		if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"member_address WHERE aid="& V("aid") &" AND uid="& UID &"") then
			call UC.errorSetting("收货地址不存在") : exit function
		end if
		result = OW.DB.execute("UPDATE ["& DB_PRE &"member_address] SET is_default=1 WHERE aid="& V("aid") &" AND uid="& UID &"")
		if result then
			call OW.DB.execute("UPDATE ["& DB_PRE &"member_address] SET is_default=0 WHERE aid<>"& V("aid") &" AND uid="& UID &"")
		end if
		UC.actionFinishSuccess     = result
		UC.actionFinishSuccessText = array("设置成功","")
		UC.actionFinishFailText    = array("设置失败","")
		UC.actionFinishRun()
	end function
	
	private function main()
		call UC.echoHeader()
%>
    <%=UC.htmlHeaderMobile("<a href="""& UCENTER_URL &""" class=""ucenter""></a>",UC.lang(1500))%>
    <section id="mbody">
        <div class="ow-address" id="datalist">
            <div class="section-do">
                <a class="btn-a" href="<%=UCENTER_HURL%>ctl=address&act=add" id="add_new"><i class="glyphicon glyphicon-plus"></i><%=UC.lang(1501)%></a>
            </div>
            <div class="section-list" id="list">
                <%=addressList()%>
            </div>
        </div>
    </section>
    <script type="text/javascript">
    $(window).ready(function(){
		//**默认
		$("a[name='set_default']").click(function(){
			var aid = $(this).attr("value"),
			url     = "<%=UCENTER_HURL%>ctl=<%=CTL%>&act=set_default&save=true",
			$dialog = UC.dialogPosting();
			OW.ajax({
				me:"",url:url,data:"aid="+aid,
				success:function(){
					$dialog.success("<%=UC.lang(162)%>").position();
					OW.delay(2000,function(){
						OW.refresh();
					});
				},
				failed:function(msg){
					$dialog.error('<%=UC.lang(163)%>',msg).position().timeout(4);
					OW.setDisabled($("button[name='submit']"),false);
				}
			});
		});
		//**删除
		$("a[name='delete']").click(function(){
			if(confirm("<%=UC.lang(151)%>")){
				var aid = $(this).attr("value"),
				url     = "<%=UCENTER_HURL%>ctl=<%=CTL%>&act=delete",
				$dialog = UC.dialogPosting();
				OW.ajax({
					me:"",url:url,data:"aid="+aid,
					success:function(){
						$dialog.success("<%=UC.lang(152)%>").position();
						OW.delay(2000,function(){
							OW.refresh();
						});
					},
					failed:function(msg){
						$dialog.error('<%=UC.lang(153)%>',msg).position().timeout(4);
						OW.setDisabled($("button[name='submit']"),false);
					}
				});
			};
		});
	});
    </script>
    <%UC.isShowNav=false%>
	<%=UC.htmlFooter()%>
<%
		call UC.echoFooter()
	end function
	
	public function addressList()
		dim aid,arr,i,rs
		dim sb,str : set sb = OW.stringBuilder()
		set rs = OW.DB.getRecordBySQL( "SELECT * FROM "& DB_PRE &"member_address WHERE uid="& UID &" ORDER BY aid ASC")
		do while not(rs.eof)
			aid = OW.int(rs("aid"))
			sb.append "<div class=""ow-address-list"">"
			sb.append "<div class=""hd"">"
			sb.append OW.rs(rs("address_name"))
			if OW.int(rs("is_default"))=1 then
			sb.append "<span class=""default"">"& UC.lang(1503) &"</span>"
			end if
			sb.append "</div>"
			sb.append "<div class=""bd"">"
			sb.append "<div class=""consignee""><span class=""name"">"& OW.rs(rs("consignee")) &"</span><span class=""mobile"">"& OW.rs(rs("mobile")) &"</span></div>"
			sb.append "<div class=""address"">"& OS.getRegionName(OW.rs(rs("region")),false) & OW.rs(rs("address")) &"</div>"
			sb.append "</div>"
			sb.append "<div class=""do"">"
			if OW.int(rs("is_default"))<>1 then
			sb.append "<a class=""default"" href=""javascript:;"" name=""set_default"" value="""& aid &""">"& UC.lang(1504) &"</a>"
			end if
			sb.append "<a href="""& UCENTER_HURL &"ctl=address&act=edit&aid="& aid &""">"& UC.lang(164) &"</a><a href=""javascript:;"" name=""delete"" value="""& aid &""">"& UC.lang(150) &"</a>"
			sb.append "</div>"
			sb.append "</div>"
			rs.movenext
		loop
		OW.DB.closeRs rs
		str = sb.toString() : set sb = nothing
		addressList = str
	end function
	
	private function add()
		call doingHtml()
	end function
	
	private function addSave()
		call doingSave()
	end function
	
	private function edit()
		dim rs
		V("aid") = OW.int(OW.getForm("get","aid"))
		set rs   = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"member_address WHERE aid="& V("aid") &" AND uid="& UID &"")
		if rs.eof then
			V("data_exist")   = false
		else
			V("data_exist")   = true
			V("address_name") = OW.parseNbsp(OW.rs(rs("address_name")))
			V("region")       = OW.parseNbsp(OW.rs(rs("region")))
			V("address")      = OW.parseNbsp(OW.rs(rs("address")))
			V("consignee")    = OW.parseNbsp(OW.rs(rs("consignee")))
			V("mobile")       = OW.parseNbsp(OW.rs(rs("mobile")))
		end if
		OW.DB.closeRs rs
		'**
		if not(V("data_exist")) then call UC.errorSetting("收货地址不存在") : exit function : end if
		call doingHtml()
	end function
	
	private function editSave()
		dim rs
		V("aid") = OW.int(OW.getForm("get","aid"))
		if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"member_address WHERE aid="& V("aid") &" AND uid="& UID &"") then
			call UC.errorSetting("收货地址不存在") : exit function
		end if
		call doingSave()
	end function
	
	private function doingHtml()
		call UC.echoHeader()
%>
    <%=UC.htmlHeaderMobile("<a href="""& UCENTER_URL &"?ctl="& CTL &""" class=""goback""></a>",UC.lang(1500))%>
    <section id="mbody">
        <div id="save_form">
            <div class="owui-cells owui-cells-first">
                <div class="owui-cell">
                    <div class="owui-cell-hd"><label class="owui-label"><i class="important">*</i>所在地区</label></div>
                    <div class="owui-cell-bd owui-cell-bd-select">
                        <span id="region_select_grid" class="region"></span><span name="t_address_region" class="t-normal ml5"></span>
                        <script type="text/javascript" src="<%=SITE_URL%>ow-content/data/ow.region.js"></script>
                        <script type="text/javascript">$(document).ready(function(){OW.createRegionSelect($("#region_select_grid"),"address_region","<%=V("region")%>");});</script>
                    </div>
                </div>
                <div class="owui-cell">
                    <div class="owui-cell-hd"><label class="owui-label"><i class="important">*</i>详细地址</label></div>
                    <div class="owui-cell-bd"><input type="text" class="owui-input" name="address" maxlength="250" value="<%=V("address")%>" placeholder="详细地址 街道 门牌号" datatype="*" errmsg="请填写详细地址 街道 门牌号" tips="" /></div>
                </div>
                <div class="owui-cell">
                    <div class="owui-cell-hd"><label class="owui-label"><i class="important">*</i>收货人</label></div>
                    <div class="owui-cell-bd"><input type="text" class="owui-input" name="consignee" maxlength="100" value="<%=V("consignee")%>" datatype="*" errmsg="请填写收货人" tips="" /></div>
                </div>
                <div class="owui-cell">
                    <div class="owui-cell-hd"><label class="owui-label"><i class="important">*</i>手机号码</label></div>
                    <div class="owui-cell-bd"><input type="text" class="owui-input" name="mobile" maxlength="15" value="<%=V("mobile")%>" datatype="*" errmsg="请填写手机号码" tips="" /></div>
                </div>
                <div class="owui-cell">
                    <div class="owui-cell-hd"><label class="owui-label">地址别名</label></div>
                    <div class="owui-cell-bd"><input type="text" class="owui-input" name="address_name" maxlength="100" value="<%=V("address_name")%>" placeholder="地址备注 可不填写"  /></div>
                </div>
            </div>
            <div class="owui-btn-area">
                <button type="submit" class="owui-btn owui-btn-primary" id="submit"><%=UC.lang(155)%></button>
            </div>
        </div>
    </section>
    <script type="text/javascript">
    $(window).ready(function(){
		var $saveForm = $("#save_form");
		$("#submit").click(function(){
			OW.parseFormInputValue({form:$saveForm});
			var isRegioned,$validForm,
			valid          = true,
			regionData     = "region_data=",
			$regionSelect  = $("select[is_region='1']"),
			$regionTipSpan = $("span[name='t_address_region']");
			$validForm = OWValidForm({form:$saveForm});
			$validForm.verify();
			if($regionSelect.length>0){
				$regionTipSpan.removeClass("t-err").html("");
				$regionSelect.each(function(){
					if(!OW.int($(this).val())>0){
						valid = false;
						$(this).focus();
						alert("请选择所在地区");
					};
					regionData = "region_data="+$(this).find("option:selected").attr("path");
				});
			};
			if($validForm.result && valid){
				var $dialog = UC.dialogPosting();
				var url = "?ctl=<%=CTL%>&act=<%=ACT%>&aid=<%=V("aid")%>&save=true";
				$validForm.getFormData();
				OW.ajax({
					me:"",url:url,data:regionData+"&"+$validForm.formData,
					success:function(){
						var id = OW.ajaxData.id;
						$dialog.success("<%=UC.lang(158)%>").position();
						OW.delay(2000,function(){
							OW.redirect("?ctl=<%=CTL%>");
						});
					},
					failed:function(msg){
						$dialog.error('<%=UC.lang(157)%>',msg).position().timeout(4);
						OW.setDisabled($("#submit"),false);
					}
				});
			};
		});
	});
    </script>
	<%=UC.htmlFooter()%>
<%
		call UC.echoFooter()
	end function
	
	private function doingSave()
		dim rs,result,valid
		valid            = true
		V("region")      = OW.left(OW.regReplace(OW.getForm("post","region_data"),"[^0-9,]",""),100)
		V("address_name")= OW.validClientDBData(OW.getForm("post","address_name"),100)
		V("address")     = OW.validClientDBData(OW.getForm("post","address"),250)
		V("consignee")   = OW.validClientDBData(OW.getForm("post","consignee"),100)
		V("mobile")      = OW.validClientDBData(OW.getForm("post","mobile"),100)
		if V("region")="" then
			UC.errorSetting("请先选择所在地区；") : valid = false
		end if
		if V("address")="" then
			UC.errorSetting("详细地址必须填写；") : valid = false
		end if
		if V("consignee")="" then
			UC.errorSetting("收货人必须填写；") : valid = false
		end if
		if V("mobile")="" then
			UC.errorSetting("手机号码必须填写；") : valid = false
		end if
		if ACT="eidt" then
			if not(V("aid"))>0 then
				UC.errorSetting("aid参数传递错误；") : valid = false
			end if
		end if
		if valid then
			if ACT="add" then
				result = OW.DB.addRecord(DB_PRE &"member_address",array("uid:"& UID,"is_default:0","address_name:"& V("address_name"),"region:"& V("region"),"address:"& V("address"),"consignee:"& V("consignee"),"mobile:"& V("mobile")))
			end if
			if ACT="edit" then
				result = OW.DB.updateRecord(DB_PRE &"member_address",array("address_name:"& V("address_name"),"region:"& V("region"),"address:"& V("address"),"consignee:"& V("consignee"),"mobile:"& V("mobile")),array("aid:"& V("aid"),"uid:"& UID))
			end if
			UC.actionFinishSuccess     = result
			UC.actionFinishSuccessText = array("保存成功","")
			UC.actionFinishFailText    = array("保存失败","")
			UC.actionFinishRun()
		end if
	end function

end class
%>

