﻿//import('./eku.js');

/*
 上传组件
 src：上传成功返回的路径
 path：上传文件夹
 attr：控件唯一名称
 */
Vue.component("eku-upload", {
    props: ['src', 'path','attr'],
    //template: '<el-upload class="avatar-uploader" action="uploadImg" :http-request="uploadImg" :show-file-list="false"><img v-if="src" :src="src" class="avatar"><i v-else class="el-icon-plus avatar-uploader-icon"></i></el-upload>',
    template: '<div class="avatar"><el-upload v-if="this.src == \'\'" :before-upload="beforeAvatarUpload" class="avatar-uploader" action="uploadImg" :http-request="uploadImg" :show-file-list="false"><img v-if="src" :src="src" class="avatar"><i v-else class="el-icon-plus avatar-uploader-icon"></i></el-upload>'
        + '<ul v-else="this.src != \'\'" class="el-upload-list el-upload-list--picture-card" style="padding-left:0px;">'
        + '<li tabindex="0" class="el-upload-list__item is-success">'
        + '<img :src="src" alt="" class="el-upload-list__item-thumbnail">'
        + '<label class="el-upload-list__item-status-label"><i class="el-icon-upload-success el-icon-check"></i></label>'
        + '<span class="el-upload-list__item-actions">'
        + '<span class="el-upload-list__item-preview" @click="handlePictureCardPreview">'
        + '<i class="el-icon-zoom-in"></i>'
        + '</span>'
        + '<span class="el-upload-list__item-delete" @click="handleRemove">'
        + '<i class="el-icon-delete"></i></span></span></li >'
        + '</ul>'
        + '<el-dialog width="90%" :visible.sync="isShowDialog" :lock-scroll="false" style="text-align:center"><img width="100%" :src="src" alt="" ></el-dialog>'
        + '</div>',
    data: function () {
        return {
            isShowDialog: false,
        }
    },
    methods: {
        beforeAvatarUpload: function (file) {
            const isJPG =
                file.type === 'image/jpg' ||
                file.type === 'image/jpeg' ||
                file.type === 'image/png' ||
                file.type === 'image/bmp'
            const isLt2M = file.size / 1024 / 1024 < 20;
            if (!isJPG) {
                this.$message.error('上传图片格式不正确!');
                return false;
            }
            if (!isLt2M) {
                this.$message.error('上传图片大小不能超过 20MB!');
                return false;
            }
            return isJPG && isLt2M;
        },
        handleRemove: function() {
            this.showFileList = true;
            this.$emit('uploaded', { url: '', attr: this.attr });
        },
        handlePictureCardPreview: function() {
            this.isShowDialog = true;
        },
        uploadImg: function(item) {
            var that = this;
            this.upLoading = this.$loading({
                lock: true,
                text: '图片上传中...',
                spinner: '',
                background: 'rgba(0,0,0,0.7)'
            });
            eku.vueUpload(item.file, that.path,
                function (url) {
                    that.upLoading.close();
                    that.showFileList = false;
                    that.$emit('uploaded', { url: url, attr: that.attr });
                },
                function (errMsg) {
                    that.upLoading.close();
                    this.$message.error(errMsg);
                }
            );
        }
    }
});


//复制到剪贴板
Vue.component("eku-clipboard", {
    props: ['btnclass', 'copytext'],
    template: '<div>'
        + '<button type="button" :class="btnclass"'
        + ' v-clipboard:copy="copytext"'
        + ' v-clipboard:success="onCopy"'
        + ' v-clipboard:error="onError">'
        + '一键复制</button></div>',
    data: function () {
        return {
            message: ''
        }
    },
    methods: {
        onCopy: function (e) {
            this.$message.success("复制成功！");
        },
        onError: function (e) {
            console.dir(e);
            this.$message.error("复制失败！");
        }
    }
});