﻿
new Vue({
    el: '#app',
    data: {
    },
    methods: {
        loadCharts: function () {
            var myChart = echarts.init(document.getElementById('chartMain'), 'echartsTheme');

            var option = {
                title: {
                    text: '30天赚红包走势',
                    x: 'center',
                    textStyle: {
                        fontSize: 14
                    }
                },
                tooltip: {
                    trigger: 'axis'
                },
                legend: {
                    orient: 'vertical',
                    x: 'left',
                    data: ['红包']
                },
                xAxis: [{
                    type: 'category',
                    boundaryGap: false,
                    data: []
                }],
                yAxis: [{
                    type: 'value'
                }],
                series: [{
                    name: '红包',
                    type: 'line',
                    smooth: 0.1,
                    data: []
                }]
            };
            $.ajax({
                url: '/Member/Home/GetTaskOrderMoneyStatis',
                type: 'Get',
                data: {},
                dataType: 'json',
                success: function (res) {
                    if (res.code == 0) {
                        var opt = option;
                        opt.xAxis[0].data = res.data.daysData;
                        opt.series[0].data = res.data.orderMoneyData;
                        myChart.setOption(opt);

                    }
                }
            });
        },

    },
    created: function () {

    },
    mounted: function () {
        this.loadCharts();
    }
});