﻿var vueDoTask = new Vue({
    el: "#vueDoTask",
    data: {
        taskId: -1,//任务编号
        orderId: -1,//订单编号
        inputTitle: '',//用户输入的标题
        isCheckTitle: false,//验证商品标题是否通过
        //isCollection: false,//验证收藏
        //isCar: false,//验证加购
        formLookData: {
            collectGoodsPic: '',
            collectShopPic: ''
        },
        contrastNum: -1,//货比数量
        browseNum: -1,//副宝贝数量
        formPayData: {
            contrastPic: { pic1: '', pic2: '', pic3: '' },
            browsePic: { pic1: '', pic2: '', pic3: '' },
            orderNo: '',
            payMoney: 0,
            payPic: '',
            orderId: -1
        },
        formReceivData: {
            remarkPic: '',
            //remarkText:'',
            appendRemarkPic: '',
            //appendRemarkText:'',
            orderId: -1
        },
        attachmentList: [],
        isDisabledNext: true,//是否禁用下一步按钮
        submitLoading: false, //下一步按钮显示等待
        exampleHtml: '',
        channelId: 0,
        platformId: 0,
        tipDialogVisible: false
    },
    methods: {
        upload: function (obj) {
            this.$data[obj.attr] = obj.url;
        },
        uploadLookPic: function (obj) {
            this.$data.formLookData[obj.attr] = obj.url;
        },
        uploadContrast: function (obj) {
            this.$data.formPayData.contrastPic[obj.attr] = obj.url;
        },
        uploadBrowsePic: function (obj) {
            this.$data.formPayData.browsePic[obj.attr] = obj.url;
        },
        uploadPayPic: function (obj) {
            this.$data.formPayData[obj.attr] = obj.url;
        },
        uploadReceivPic: function (obj) {
            this.$data.formReceivData[obj.attr] = obj.url;
        },
        checkTitle: function () {
            var that = this;
            if (that.inputTitle == '') {
                that.$message.error({ message: "请输入商品标题的前3个字！", offset: 45 });
                return;
            }
            if (that.inputTitle.length < 3) {
                that.$message.error({ message: "请输入商品标题的前3个字！", offset: 45 });
                return;
            }
            if (that.orderId <= 0 || that.taskId <= 0) {
                that.$message.error({ message: "任务编号错误", offset: 45 });
                return;
            }
            $.ajax({
                url: '/Api/TaskMoney/CheckTile',
                type: 'POST',
                data: { title: that.inputTitle, taskId: that.taskId },
                dataType: 'json',
                success: function (res) {
                    if (res.code == 0) {
                        that.isCheckTitle = true;
                        that.isDisabledNext = false;
                        that.$message.success({ message: res.msg, offset: 45 });
                    }
                    else {
                        that.isCheckTitle = false;
                        that.$message.error({ message: res.msg, offset: 45 });
                    }
                }
            });
        },
        btnLook: function () {
            var that = this;
            if (!that.isCheckTitle) {
                that.$message.success({ message: "请先核对商品标题！", offset: 45 });
                return;
            }
            $.ajax({
                url: '/Api/TaskMoney/GoLookGoods',
                type: 'POST',
                data: {
                    orderId: that.orderId,
                    collectGoodsPic: that.formLookData.collectGoodsPic,
                    collectShopPic: that.formLookData.collectShopPic,
                },
                dataType: 'json',
                beforeSend: function () {
                    that.isDisabledNext = true;
                    that.submitLoading = true;
                },
                success: function (res) {
                    if (res.code == 0) {
                        that.$message.success({ message: res.msg, offset: 45 });
                        location.href = location.href;
                    }
                    else {
                        that.isDisabledNext = false;
                        that.submitLoading = false;
                        that.$message.error({ message: res.msg + "，错误代码：" + res.code, offset: 45 });
                    }
                }
            });
        },
        btnPay: function () {
            var that = this;
            if (that.orderId <= 0 || that.taskId <= 0) {
                that.$message.error({ message: "任务编号错误", offset: 45 });
                return;
            }
            if (that.contrastNum > 0) {
                if (that.contrastNum >= 1 && that.formPayData.contrastPic.pic1 == '') {
                    that.$message.error({ message: "请上传货比截图", offset: 45 });
                    return;
                }
                if (that.contrastNum >= 2
                    && (that.formPayData.contrastPic.pic1 == ''
                        || that.formPayData.contrastPic.pic2 == '')) {
                    that.$message.error({ message: "请上传货比截图", offset: 45 });
                    return;
                }
                if (that.contrastNum >= 3
                    && (that.formPayData.contrastPic.pic1 == ''
                        || that.formPayData.contrastPic.pic2 == ''
                        || that.formPayData.contrastPic.pic3 == '')) {
                    that.$message.error({ message: "请上传货比截图", offset: 45 });
                    return;
                }
            }
            if (that.browseNum > 0) {
                if (that.contrastNum >= 1 && that.formPayData.browsePic.pic1 == '') {
                    that.$message.error({ message: "请上传浏览副宝贝截图", offset: 45 });
                    return;
                }
                if (that.browseNum >= 2
                    && (that.formPayData.browsePic.pic1 == ''
                        || that.formPayData.browsePic.pic2 == '')) {
                    that.$message.error({ message: "请上传浏览副宝贝截图", offset: 45 });
                    return;
                }
                if (that.browseNum >= 3
                    && (that.formPayData.browsePic.pic1 == ''
                        || that.formPayData.browsePic.pic2 == ''
                        || that.formPayData.browsePic.pic3 == '')) {
                    that.$message.error({ message: "请上传浏览副宝贝截图", offset: 45 });
                    return;
                }
            }
            if (that.formPayData.orderNo == '') {
                that.$message.error({ message: "请填写订单编号", offset: 45 });
                return;
            }
            if (that.formPayData.payMoney == '') {
                that.$message.error({ message: "请填写付款金额", offset: 45 });
                return;
            }
            if (that.formPayData.payPic == '') {
                that.$message.error({ message: "请上传付款截图", offset: 45 });
                return;
            }
            that.formPayData.orderId = that.orderId;
            $.ajax({
                url: '/Api/TaskMoney/GoPayGoods',
                type: 'POST',
                data: that.formPayData,
                dataType: 'json',
                success: function (res) {
                    if (res.code == 0) {
                        that.$message.success({ message: res.msg, offset: 45 });
                        location.href = location.href;
                    }
                    else {
                        that.submitLoading = true;
                        that.$message.error({ message: res.msg + "，错误代码：" + res.code, offset: 45 });
                    }
                }
            });
        },
        btnReceiv: function () {
            var that = this;
            if (that.orderId <= 0 || that.taskId <= 0) {
                that.$message.error({ message: "任务编号错误", offset: 45 });
                return;
            }
            if (that.formReceivData.remarkPic == '') {
                that.$message.error({ message: "请上传好评截图", offset: 45 });
                return;
            }
            //if (that.formReceivData.appendRemarkPic == '') {
            //    that.$message.error({ message: "请上传追评截图", offset: 45 });
            //    return;
            //}
            that.formReceivData.orderId = that.orderId;
            $.ajax({
                url: '/Api/TaskMoney/GoReceivGoods',
                type: 'POST',
                data: that.formReceivData,
                dataType: 'json',
                success: function (res) {
                    if (res.code == 0) {
                        that.$message.success({ message: res.msg, offset: 45 });
                        location.href = location.href;
                    }
                    else {
                        that.submitLoading = true;
                        that.$message.error({ message: res.msg + "，错误代码：" + res.code, offset: 45 });
                    }
                }
            });
        },
        example: function (opt) {
            var that = this;
            $.ajax({
                url: "/Api/Account/GetExample",
                type: 'get',
                data: {
                    opt: opt, plat: that.platformId, channelId: that.channelId
                },
                dataType: 'json',
                success: function (data) {
                    if (data) {
                        that.exampleHtml = data.html;
                        that.tipDialogVisible = true;
                    }
                }
            });
        },
    }
});
