﻿new Vue({
    el: '#app',
    data: {
    },
    methods: {
        loadCharts: function () {
            var myChart = echarts.init(document.getElementById('chartMain'), 'echartsTheme');

            var option = {
                title: {
                    text: '一周任务趋势',
                    x: 'center',
                    textStyle: {
                        fontSize: 14
                    }
                },
                tooltip: {
                    trigger: 'axis'
                },
                legend: {
                    orient: 'vertical',
                    x: 'left',
                    data: ['发布量', '接单量']
                },
                xAxis: [{
                    type: 'category',
                    boundaryGap: false,
                    data: []
                }],
                yAxis: [{
                    type: 'value'
                }],
                series: [{
                    name: '发布量',
                    type: 'line',
                    smooth: true,
                    itemStyle: { normal: { areaStyle: { type: 'default' } } },
                    data: []
                }, {
                    name: '接单量',
                    type: 'line',
                    smooth: true,
                    itemStyle: { normal: { areaStyle: { type: 'default' } } },
                    data: []
                }]
            };
            $.ajax({
                url: '/Member/Home/GetTaskOrderStatis',
                type: 'Get',
                data: {},
                dataType: 'json',
                success: function (res) {
                    if (res.code == 0) {
                        var opt = option;
                        opt.xAxis[0].data = res.data.daysData;
                        opt.series[0].data = res.data.taskData;
                        opt.series[1].data = res.data.orderData;
                        // 使用刚指定的配置项和数据显示图表。
                        myChart.setOption(opt);

                    }
                }
            });
        },

    },
    created: function () {

    },
    mounted: function () {
        this.loadCharts();
    }
});