/**
 * jQuery༶˵
 * 
 * Author:	ZhouFan <happyeddie@gmail.com>
 * 
 */
 
function LinkageSelect(options) {
	
	var bindEls	= new Array();
	var items	= {};
	
	// Ĭϲ
	var settings = {
		data		: {},
		file		: null,
		root		: '0',
		ajax		: null,
		timeout		: 30,
		method		: 'post'
	}; 
	
	// Զ
	if(options) {  
		jQuery.extend(settings, options); 
	}
	
	items	= settings.data;
	
	/**
	 * Ԫ
	 * @param {Object} element
	 * @param {Object} value
	 */
	function _bind(element , key , value) {
		
		// id
		for (var el_id in bindEls) {
			if (bindEls[el_id].element == element) {
				var self_id	= el_id;
			}
		}
		
		for(var el_id in bindEls){
			
			// ΪǰĶonchange¼onchangeʱ
			if (el_id < self_id){
				bindEls[el_id].element.change(function() {
					_fill(element);
				})
			}
			
		}
		
		// Ϊһonchange¼ˢб
		if (self_id > 0) {
			bindEls[self_id-1].element.change(function() {
				var self_key	= $(this).val()?bindEls[self_id-1].key + ',' + $(this).val():'';
				bindEls[self_id].key	= self_key;
				_fill(element , self_key);
			});
		}
		
		_fill(element , key , value);
		
	}
	
	/**
	 * option
	 * @param {Object} element
	 * @param {Object} key
	 * @param {Object} value
	 */
	function _fill(element , key , value) {
		element.empty();
		element.append('<option value="">ѡ</option>');
		
		var json	= _find(key , function() {
			_fill(element , key , value);
		});
		
		if (!json) {
			return false;
		}
		
		var index	= 1;
		var selected_index	= 0;
		for(var opt_value in json) {
			var opt_title	= json[opt_value];
			var selected	= '';
			if (opt_value == value) {
				selected_index	= index;
				selected		= 'selected="selected"';
			}
			var option	= $('<option value="' + opt_value + '" ' + selected + '>' + opt_title + '</option>');
			element.append(option);
			index++;
		}
		
		if (element[0]) {
			//IE6
			setTimeout(function(){
				element[0].options[selected_index].selected = true;
			}, 0);
			// FFѡĬ
			element[0].selectedIndex	= 0;
			element.attr('selectedIndex' , selected_index);
		}
		
	}
	
	/**
	 * Ԫ
	 * @param {Object} key
	 */
	function _find(key , callback) {

		if (typeof key == 'undefined') {	// δkey
			return null;
		} else if (key[key.length-1] == ',') {	// key','β϶ȡֵ
			return null
		} else if(typeof(items[key]) == "undefined") {
			
			// itemsԪظ
			var item_count	= 0;
			for (var i in items) {
				item_count++;
				break;
			}
			
			if (settings.ajax) {
				$.getJSON(settings.ajax , {key:key} , function(json) {
					items[key] = json;
					callback();
				})
			} else if(settings.file && item_count == 0) {
				$.getJSON(settings.file , function(json) {
					items = json;
					callback();
				})
			}
		}
			
		return items[key];
	}
	
	/**
	 * ȡ
	 * @param {Object} element
	 */
	function _getEl(element) {
		if (typeof element == 'string') {
			return $(element);
		} else {
			return element;
		}
	}
	
	
	return {
		
		// Ԫ
		bind	: function(element , value) {
			element	= _getEl(element);
			value	= value?value:'';
			
			// key
			var key	= bindEls.length ?
				bindEls[bindEls.length - 1].key + ',' + bindEls[bindEls.length - 1].value :
				settings.root;
			
			// 󶨵Ԫط
			bindEls.push({
				element	: element,
				key		: key,
				value	: value
			});
			
			var item_count	= 0;
			for (var i in items) {
				item_count++;
			}
			
			_bind(element , key , value);
			
		}
	}
	
}