<%
Option Explicit        ' ʾ
dim mCode
Set mCode = New Com_GifCode_Class
Session("Cnbbr_RndCode") = mCode.Create()    ' ֤浽Session
mCode.Output()    ' 
Set mCode = Nothing

Class Com_GifCode_Class
    '''''''''''''''''''''''''''''''''''''''''''''
    ' Author: Layen support@ssaw.net 84815733(QQ)
    ' Thanks: Laomi, Laomiao, NetRube
    '                                  2006-01-02
    '''''''''''''''''''''''''''''''''''''''''''''
    Public Noisy, Count, Width, Height, Angle, Offset, Border

    Private Graph(), Margin(3)

    Private sub Class_Initialize()
        Randomize
        Noisy    = 3    	' ŵֵĸ
        Count    = 6    	' ַ
        Width    = 80    	' ͼƬ
        Height    = 18    	' ͼƬ߶
        Angle    = 2    	' Ƕ仯
        Offset    = 20    	' ƫ仯
        Border = 1    		' ߿С
    end sub

    Public function Create()

        Const cCharSet = "123456789"

        dim i, x, y

        dim vValidCode : vValidCode = ""
        dim vIndex

        Redim Graph(Width-1, Height-1)

        for i = 0 To Count - 1
            vIndex = Int(Rnd * Len(cCharSet))
            vValidCode = vValidCode + Mid(cCharSet, vIndex+1 , 1)
            SetDraw vIndex, i
        next

        Create = vValidCode

    end function

    sub SetDot(pX, pY)
        if pX * (Width-pX-1) >= 0 And pY * (Height-pY-1) >= 0 Then
            Graph(pX, pY) = 1
        end if
    end sub

    Public sub SetDraw(pIndex, pNumber)

        ' ַ
        dim DotData(8)
        DotData(0) = Array(30, 15, 50, 1, 50, 100)
        DotData(1) = Array(1 ,34 ,30 ,1 ,71, 1, 100, 34, 1, 100, 93, 100, 100, 86)
        DotData(2) = Array(1, 1, 100, 1, 42, 42, 100, 70, 50, 100, 1, 70)
        DotData(3) = Array(100, 73, 6, 73, 75, 6, 75, 100)
        DotData(4) = Array(100, 1, 1, 1, 1, 50, 50, 35, 100, 55, 100, 80, 50, 100, 1, 95)
        DotData(5) = Array(100, 20, 70, 1, 20, 1, 1, 30, 1, 80, 30, 100, 70, 100, 100, 80, 100, 60, 70, 50, 30, 50, 1, 60)
        DotData(6) = Array(6, 26, 6, 6, 100, 6, 53, 100)
        DotData(7) = Array(100, 30, 100, 20, 70, 1, 30, 1, 1, 20, 1, 30, 100, 70, 100, 80, 70, 100, 30, 100, 1, 80, 1, 70, 100, 30)
        DotData(8) = Array(1, 80, 30, 100, 80, 100, 100, 70, 100, 20, 70, 1, 30, 1, 1, 20, 1, 40, 30, 50, 70, 50, 100, 40)

        dim vExtent : vExtent = Width / Count
        Margin(0) = Border + vExtent * (Rnd * Offset) / 100 + Margin(1)
        Margin(1) = vExtent * (pNumber + 1) - Border - vExtent * (Rnd * Offset) / 100
        Margin(2) = Border + Height * (Rnd * Offset) / 100
        Margin(3) = Height - Border - Height * (Rnd * Offset) / 100

        dim vStartX, vEndX, vStartY, vEndY
        dim vWidth, vHeight, vDX, vDY, vDeltaT

        dim vAngle, vLength

        vWidth = Int(Margin(1) - Margin(0))

        vHeight = Int(Margin(3) - Margin(2))

        ' ʼ
        vStartX = Int((DotData(pIndex)(0)-1) * vWidth / 100)

        vStartY = Int((DotData(pIndex)(1)-1) * vHeight / 100)

        dim i, j
        for i = 1 To UBound(DotData(pIndex), 1)/2

            if DotData(pIndex)(2*i-2) <> 0 And DotData(pIndex)(2*i) <> 0 Then

                ' յ
                vEndX = (DotData(pIndex)(2*i)-1) * vWidth / 100

                vEndY = (DotData(pIndex)(2*i+1)-1) * vHeight / 100

                ' 
                vDX = vEndX - vStartX
                ' 
                vDY = vEndY - vStartY

                ' бǶ
                if vDX = 0 Then
                    vAngle = Sgn(vDY) * 3.14/2
                else
                    vAngle = Atn(vDY / vDX)
                end if

                ' 
                if Sin(vAngle) = 0 Then
                    vLength = vDX
                else
                    vLength = vDY / Sin(vAngle)
                end if

                ' תǶ
                vAngle = vAngle + (Rnd - 0.5) * 2 * Angle * 3.14 * 2 / 100

                vDX = Int(Cos(vAngle) * vLength)

                vDY = Int(Sin(vAngle) * vLength)

                if Abs(vDX) > Abs(vDY) Then vDeltaT = Abs(vDX) else vDeltaT = Abs(vDY)

                for j = 1 To vDeltaT
                    SetDot Margin(0) + vStartX + j * vDX / vDeltaT, Margin(2) + vStartY + j * vDY / vDeltaT
                next

                vStartX = vStartX + vDX

                vStartY = vStartY + vDY
            end if
        next
    end sub

    Public sub Output()

        response.Expires = -9999
        response.AddHeader "pragma", "no-cache"
        response.AddHeader "cache-ctrol", "no-cache"
        response.ContentType = "image/gif"

        ' ļ
        response.BinaryWrite ChrB(Asc("G")) & ChrB(Asc("I")) & ChrB(Asc("F"))
        ' 汾Ϣ
        response.BinaryWrite ChrB(Asc("8")) & ChrB(Asc("9")) & ChrB(Asc("a"))
        ' ߼Ļ
        response.BinaryWrite ChrB(Width Mod 256) & ChrB((Width \ 256) Mod 256)
        ' ߼Ļ߶
        response.BinaryWrite ChrB(Height Mod 256) & ChrB((Height \ 256) Mod 256)

        response.BinaryWrite ChrB(128) & ChrB(0) & ChrB(0)
        ' ȫɫб
        response.BinaryWrite ChrB(255) & ChrB(255) & ChrB(255)

        response.BinaryWrite ChrB(0) & ChrB(85) & ChrB(255)

        ' ͼʶ
        response.BinaryWrite ChrB(Asc(","))

        response.BinaryWrite ChrB(0) & ChrB(0) & ChrB(0) & ChrB(0)
        ' ͼ
        response.BinaryWrite ChrB(Width Mod 256) & ChrB((Width \ 256) Mod 256)
        ' ͼ߶
        response.BinaryWrite ChrB(Height Mod 256) & ChrB((Height \ 256) Mod 256)

        response.BinaryWrite ChrB(0) & ChrB(7) & ChrB(255)

        dim x, y, i : i = 0
        for y = 0 To Height - 1
            for x = 0 To Width - 1
                if Rnd < Noisy / 100 Then
                    response.BinaryWrite ChrB(1-Graph(x, y))
                else
                    if x * (x-Width) = 0 Or y * (y-Height) = 0 Then
                        response.BinaryWrite ChrB(Graph(x, y))
                    else
                        if Graph(x-1, y) = 1 Or Graph(x, y) Or Graph(x, y-1) = 1 Then
                            response.BinaryWrite ChrB(1)
                        else
                            response.BinaryWrite ChrB(0)
                        end if
                    end if
                end if
                if (y * Width + x + 1) Mod 126 = 0 Then
                    response.BinaryWrite ChrB(128)
                    i = i + 1
                end if
                if (y * Width + x + i + 1) Mod 255 = 0 Then
                    if (Width*Height - y * Width - x - 1) > 255 Then
                        response.BinaryWrite ChrB(255)
                    else
                        response.BinaryWrite ChrB(Width * Height Mod 255)
                    end if
                end if
            next
        next
        response.BinaryWrite ChrB(128) & ChrB(0) & ChrB(129) & ChrB(0) & ChrB(59)
    end sub
End Class


%>
