<%
'
'	VBS JSON 2.0.3
'	Copyright (c) 2009 Tu ul Topuz
'	Under the MIT (MIT-LICENSE.txt) license.
'   URI: http://code.google.com/p/aspjson/

Const JSON_OBJECT	= 0
Const JSON_ARRAY	= 1

Class jsCore
	Public Collection
	Public Count
	Public QuotedVars
	Public Kind 	' 0 = object, 1 = array

	Private sub Class_Initialize
		Set Collection = CreateObject("Scripting.Dictionary")
		QuotedVars = True
		Count = 0
	end sub

	Private sub Class_Terminate
		Set Collection = Nothing
	end sub

	' counter
	Private Property Get Counter 
		Counter = Count
		Count = Count + 1
	End Property

	' - data maluplation
	' -- pair
	Public Property Let Pair(p, v)
		if IsNull(p) Then p = Counter
		Collection(p) = v
	End Property

	Public Property Set Pair(p, v)
		if IsNull(p) Then p = Counter
		if TypeName(v) <> "jsCore" Then
			Err.Raise &hD, "class: class", "Incompatible types: '" & TypeName(v) & "'"
		end if
		Set Collection(p) = v
	End Property

	Public Default Property Get Pair(p)
		if IsNull(p) Then p = Count - 1
		if IsObject(Collection(p)) Then
			Set Pair = Collection(p)
		else
			Pair = Collection(p)
		end if
	End Property
	' -- pair
	Public sub Clean
		Collection.RemoveAll
	end sub

	Public sub Remove(vProp)
		Collection.Remove vProp
	end sub
	' data maluplation

	' encoding
	function jsEncode(str)
		dim charmap(127), haystack()
		charmap(8)  = "\b"
		charmap(9)  = "\t"
		charmap(10) = "\n"
		charmap(12) = "\f"
		charmap(13) = "\r"
		charmap(34) = "\"""
		charmap(47) = "\/"
		charmap(92) = "\\"

		dim strlen : strlen = Len(str) - 1
		Redim haystack(strlen)

		dim i, charcode
		for i = 0 To strlen
			haystack(i) = Mid(str, i + 1, 1)

			charcode = AscW(haystack(i)) And 65535
			if charcode < 127 Then
				if Not IsEmpty(charmap(charcode)) Then
					haystack(i) = charmap(charcode)
				elseif charcode < 32 Then
					haystack(i) = "\u" & Right("000" & Hex(charcode), 4)
				end if
			else
				haystack(i) = "\u" & Right("000" & Hex(charcode), 4)
			end if
		next

		jsEncode = Join(haystack, "")
	end function

	' converting
	Public function toJSON(vPair)
		Select Case VarType(vPair)
			Case 0	' Empty
				toJSON = "null"
			Case 1	' Null
				toJSON = "null"
			Case 7	' Date
				' toJSON = "new Date(" & (vPair - CDate(25569)) * 86400000 & ")"	' let in only utc time
				toJSON = """" & cstr(vPair) & """"
			Case 8	' String
				toJSON = """" & jsEncode(vPair) & """"
			Case 9	' Object
				dim bFI,i 
				bFI = True
				if vPair.Kind Then toJSON = toJSON & "[" else toJSON = toJSON & "{"
				for Each i In vPair.Collection
					if bFI Then bFI = False else toJSON = toJSON & ","
					if vPair.Kind Then 
						toJSON = toJSON & toJSON(vPair(i))
					else
						if QuotedVars Then
							toJSON = toJSON & """" & i & """:" & toJSON(vPair(i))
						else
							toJSON = toJSON & i & ":" & toJSON(vPair(i))
						end if
					end if
				next
				if vPair.Kind Then toJSON = toJSON & "]" else toJSON = toJSON & "}"
			Case 11
				if vPair Then toJSON = "true" else toJSON = "false"
			Case 12, 8192, 8204
				toJSON = RenderArray(vPair, 1, "")
			Case else
				toJSON = Replace(vPair, ",", ".")
		End select
	end function

	function RenderArray(arr, depth, parent)
		dim first : first = LBound(arr, depth)
		dim last : last = UBound(arr, depth)

		dim index, rendered
		dim limiter : limiter = ","

		RenderArray = "["
		for index = first To last
			if index = last Then
				limiter = ""
			end if

			On Error Resume next
			rendered = RenderArray(arr, depth + 1, parent & index & "," )

			if Err = 9 Then
				On Error GoTo 0
				RenderArray = RenderArray & toJSON(Eval("arr(" & parent & index & ")")) & limiter
			else
				RenderArray = RenderArray & rendered & "" & limiter
			end if
		next
		RenderArray = RenderArray & "]"
	end function

	Public Property Get jsString
		jsString = toJSON(Me)
	End Property

	sub Flush
		if TypeName(Response) <> "Empty" Then 
			response.write(jsString)
		elseif WScript <> Empty Then 
			WScript.Echo(jsString)
		end if
	end sub

	Public function Clone
		Set Clone = ColClone(Me)
	end function

	Private function ColClone(core)
		dim jsc, i
		Set jsc = new jsCore
		jsc.Kind = core.Kind
		for Each i In core.Collection
			if IsObject(core(i)) Then
				Set jsc(i) = ColClone(core(i))
			else
				jsc(i) = core(i)
			end if
		next
		Set ColClone = jsc
	end function

End Class

function jsObject
	Set jsObject = new jsCore
	jsObject.Kind = JSON_OBJECT
end function

function jsArray
	Set jsArray = new jsCore
	jsArray.Kind = JSON_ARRAY
end function

function toJSON(val)
	toJSON = (new jsCore).toJSON(val)
end function

function QueryToJSON(rsrecords)
        dim jsa, col
        Set jsa = jsArray()
        While Not (rsrecords.EOF Or rsrecords.BOF)
                Set jsa(Null) = jsObject()
                for Each col In rsrecords.Fields
                        jsa(Null)(col.Name) = col.Value
                next
        rsrecords.Movenext
        Wend
        QueryToJSON = jsa.jsString
end function
%>
