/*
Pop-up window: Version 1.0
Author: Mithell Chu

Usage: 
    var pop = new CLASS_MSN_PopWindow('MitchellChu Say:', 'PopupPlaceholder', 'Powered by CNIDCNET.COM');
    pop._Width = 300; // dispensable; default is 300
    pop._Height = 200; // dispensable; default is 200
    pop.render('<ul><li><a href="www.google.com">Link to Google.com</a></li><li><a href="www.baidu.com">Link to Baidu.com</a></li></ul>');
    
    pop.show();

Display may be like follow:
    -------------------------------
   | MitchellChu Say:            X |
   |-------------------------------|
   |   Link to Google.com          |
   |   Link to Baidu.com           |
   |-------------------------------|
   |       Powered by CNIDCNET.COM |
    -------------------------------
*/
function CLASS_MSN_PopWindow(strPopTitle, strParentId, sCopyright, sPopName)
{
    //
    this._PopTitle = strPopTitle;
    this._ParentId = strParentId;
    if(sCopyright != 'undefined')
        this._Copyright = sCopyright;
    else
        this._Copyright = "Powered by MitchellChu";
    this._Width = 220;  // default value
    this._Height = 150; // default value
    this._PLx = document.body.clientWidth - this._Width - 5;  // initialize popup window position x, the number 5 is the offset to right scroll-bar
    this._PLy = document.body.clientHeight; // initialize popup window position y
    this._PTy = this._PLy - this._Height;   // initialize popup window top-ending position y
    this._PBy = this._PLy;  // initialize popup window bottom-ending position y
    
    this._doHandle = null;
    this._doAction = '';
    
    if(sPopName == 'undefined' || sPopName == '')
        this._ObjName = 'popup';
    else
        this._ObjName = sPopName;

    this._PopHeadStyle = 'height:24px;line-height:24px;font-size:10px;background:#C1ECC8;text-align:center;';
    this._PopFootStyle ='height:18px;line-height:18px;font-size:10px;text-align:right;';
    this._PopBodyStyle = 'height:' + (this._Height - 48) + 'px;text-align:left; margin: 10px 10px 10px 10px;';
}

//*************************************
//**********CLASS PROPERTIES***********
//*************************************
CLASS_MSN_PopWindow.prototype._PopTitle;    // Pop-up window title.
CLASS_MSN_PopWindow.prototype._ParentId;    // parent container identifier.
CLASS_MSN_PopWindow.prototype._Copyright;    // Popup copyright information

CLASS_MSN_PopWindow.prototype._Width;    // Popup window width
CLASS_MSN_PopWindow.prototype._Height;    // Popup window height

// Window position
CLASS_MSN_PopWindow.prototype._PLx;
CLASS_MSN_PopWindow.prototype._PLy;
CLASS_MSN_PopWindow.prototype._PTy;
CLASS_MSN_PopWindow.prototype._PBy;

// do parameters
CLASS_MSN_PopWindow.prototype._doHandle;
CLASS_MSN_PopWindow.prototype._doAction;

// this class instance name
CLASS_MSN_PopWindow.prototype._ObjName;

// some style information
CLASS_MSN_PopWindow.prototype._PopHeadStyle;
CLASS_MSN_PopWindow.prototype._PopBodyStyle;
CLASS_MSN_PopWindow.prototype._PopFootStyle;

//*************************************
//************CLASS METHODS************
//*************************************
CLASS_MSN_PopWindow.prototype.getPopTitle = function(){
    return this._PopTitle;
}

CLASS_MSN_PopWindow.prototype.getCopyright = function(){
    return this._Copyright;
}

CLASS_MSN_PopWindow.prototype.getParentId = function(){
    return this._ParentId;
}

CLASS_MSN_PopWindow.prototype.setSize = function(pWidth, pHeight){
    this._Width = pWidth;
    this._Height = pHeight;
}

CLASS_MSN_PopWindow.prototype.setPosition = function(Px, Py){
    this._PLx = Px;
    this._PLy = Py;
}

CLASS_MSN_PopWindow.prototype.render = function(sPopHTML){
    //Pop-up window render
    // ***sPopHTML is important

    var _CONTAINER,_PopupWindow; // Pop-up window container 
    _CONTAINER = document.getElementById(this._ParentId);
    
    if(this._ParentId == 'undefined' || _CONTAINER == null){
        document.body.innerHTML += '<div id="PopupPlaceholder"></div>'; // append popup window to body, may be this is a bad method.
        this._ParentId = 'PopupPlaceholder';
    }
    
    _CONTAINER = document.getElementById(this._ParentId);

    _PopupWindow = '<div id="PopupWindow" style="position:absolute;z-index:999;width:' + this._Width + 'px;height:0px;overflow:hidden;left:' + this._PLx + 'px;top:' + this._PLy + 'px;display:none;background:#F0F8FC;">\r\n' 
                   + '  <div id="PopupHead" style="' + this._PopHeadStyle + '"><span id="PopupTitle">' + this._PopTitle + '</span> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span id="PopupClose" onClick="' + this._ObjName + '.hidden();" style="cursor: pointer">ر</span></div>\r\n'
                   + '  <div id="PopupBody" style="' + this._PopBodyStyle + '">' + sPopHTML + '</div>\r\n'
                   + '  <div id="PopupFoot" style="' + this._PopFootStyle + '">' + this._Copyright + '</div>\r\n'
                   + '</div>';

    _CONTAINER.innerHTML = _PopupWindow; // append popup window to container
}

CLASS_MSN_PopWindow.prototype.show = function(){
    // show Pop-up window
    var _PopupWindow = document.getElementById("PopupWindow");
    
    // initialize parameters
    this._PLx = parseInt(_PopupWindow.style.left);
    this._PLy = parseInt(_PopupWindow.style.top);
    _PopupWindow.style.display = "block";
    
    this._doAction = 'show';
    this._doHandle = setInterval(this._ObjName + ".active()",2);
}

CLASS_MSN_PopWindow.prototype.hidden = function(){
    // hidden Pop-up window

    var _PopupWindow = document.getElementById("PopupWindow");
    
    this._PLx = parseInt(_PopupWindow.style.left);
    this._PLy = parseInt(_PopupWindow.style.top);
    
    this._doAction = 'hidden';
    this._doHandle = setInterval(this._ObjName + ".active()",2);
}

CLASS_MSN_PopWindow.prototype.active = function(){
    // active show/hidden event to show/hidden Pop-up window.
    var _handle = this._doHandle;
    var doAction = this._doAction;
    var _PopupWindow = document.getElementById("PopupWindow");
    if(doAction == "show"){
			if(this._PLy > this._PTy){
				this._PLy -= 8; // Pop-up window subtract 8px from Ppw top-position
				_PopupWindow.style.top = this._PLy + 'px'; // set Popup window new position
				_PopupWindow.style.height = (parseInt(_PopupWindow.style.height) + 8).toString() + 'px';
			}
			else{
				clearInterval(_handle);	
				this._doHandle = null;
				this._doAction = '';
			}
    }
    else if(doAction == "hidden"){
    	if(this._PLy < this._PBy){
    		this._PLy += 8; //Pop-up window add 8px to Ppw top-position
    		_PopupWindow.style.top = this._PLy + 'px'; // set Popup window new position
    		_PopupWindow.style.height = (parseInt(_PopupWindow.style.height) - 8).toString() + 'px';
    	}
    	else{
    	  _PopupWindow.style.display = "none";
    		clearInterval(_handle);
    		this._doHandle = null;
    		this._doAction = '';
    	}
    }
}

function createRequest() {
  var xmlreq = false;
  if (window.XMLHttpRequest) {
    // Create XMLHttpRequest object in non-Microsoft browsers
    xmlreq = new XMLHttpRequest();
  } else if (window.ActiveXObject) {
    // Create XMLHttpRequest via MS ActiveX
    try {
      // Try to create XMLHttpRequest in later versions
      // of Internet Explorer
      xmlreq = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e1) {
      // Failed to create required ActiveXObject
      try {
        // Try version supported by older versions
        // of Internet Explorer
        xmlreq = new ActiveXObject("Microsoft.XMLHTTP");
      } catch (e2) {
        // Unable to create an XMLHttpRequest with ActiveX
      }
    }
  }
  return xmlreq;
}
var popup;
var _G_HANDLE;
function getWrdMng(){
    var getURI = "msgAjax.asp?randnum=" + Math.random();
    var request = createRequest();
    if(!request){
        return false;
    }
    else{
        request.open("GET",getURI,true);
        request.onreadystatechange = function()
        {
            if(request.readyState == 4)
            {
                if(request.status == 200)
                {
                    var repText = request.responseText;
                    request = false;
                    if(repText != ""){
                        popup = new CLASS_MSN_PopWindow('µϢ', 'PopupPlaceholder', ' ', 'popup');
                        popup.render(repText);
                        _G_HANDLE = setInterval("monitorDiv()",2);
                        popup.show();
                        return true;
                    }
                    else{
                        return false;
                    }
                }
            }
        }
        request.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        request.send(null);
    }
    return false;
}

function monitorDiv()
{
    var objL = document.getElementById("leftbar");
    var objR = document.getElementById("rightbar");
    if(objL != null && objL != "undefined" && objR != null && objR != "undefined"){
        ClosebarAll();
        clearInterval(_G_HANDLE);
    }
}

getWrdMng();