function refreshProduct() {
	$.post('/?controller=product&action=ajax_refresh', $("#buy-form").serialize(), function(json) {
		$('._buychoose_text').text(json.buychoose);
		$('._quantity').text(json.quantity);
		$('._selling_price').text(json.prices.selling_price.toFixed(2));
		if (json.prices.card_vip_price) {
			$('._card_vip_price').text(json.prices.card_vip_price.toFixed(2));
		}
		$('._market_price').text(json.prices.market_price.toFixed(2));
		if (json.prices.promotion_price) {
			$('._promotion_price').text(json.prices.promotion_price.toFixed(2));
		}
		
		$('input[name=selling_price]').val(json.prices.selling_price);
		$('input[name=current_price]').val(json.prices.current_price);
		$('input[name=quantity]').val(json.quantity);
		$('.plus').attr('title', json.quantity);
		if (json.quantity < 1) { //缺货禁止购买
			$('._in_stock').hide(); $('._no_stock').show();
		} else { 
			$('._in_stock').show(); $('._no_stock').hide(); 
		}
		
		selectPackage();
	}, 'json');
}

//选购项
function buychoose(t, key, ipt) {
	$(ipt).val('['+key+':'+$.trim($(t).text())+']');
	$(t).siblings('dd').removeClass('curr');
	$(t).addClass('curr');
	$('._buychoose_selected').show();
	refreshProduct();
}

//选套餐
function selectPackage() {
	var total = 0;
	var packageTotal = 0;
	var sp = Number($('input[name=selling_price]').val());
	var bp = Number($('input[name=base_price]').val());
	$('._package:checked').each(function(index, element) {
        var sellingPirce = $(this).attr('data-selling-price');
		var packagePrice = $(this).attr('data-package-price');
		total += Number(sellingPirce);
		packageTotal += Number(packagePrice);
    });
	$('._packageTotalAmount').text((packageTotal+bp).toFixed(2));
	$('._totalAmount').text((total+sp).toFixed(2));
}

//添加到收藏夹
function addFav(pid)
{
	if (!checkLogin({pid:pid}, 'addFav')) return;
	$.post('/?module=usercp&controller=favorite&action=add', {pid:pid}, function(result) {
		alert(result);
	});
}
//立即购买
function buyNow(params)
{
	if (!checkBuychoose(params, 'buyNow')) return;
	$.post('/?controller=cart&action=append', params, function(json) {
		params += '&marks='+json.marks;
		if (!checkLogin(params, 'buyNow')) return;
		window.location = '/cart/checkout/marks--'+json.marks+'.html';
	}, 'json');
}

//添加到购物车
function addCart(params)
{
	if (!checkBuychoose(params, 'addCart')) return;
	$.post('/?controller=cart&action=append', params, function(json) {
		var tip = art.dialog({
			title: '提示',
			id:'cartTip',
			fixed: true
		});
		var total_amount = json.total_amount - json.total_save;
		$('._cart_total_qty').text(json.total_quantity);
		$('._cart_total_amount').text(total_amount.toFixed(2));
		if (!json.error) {
			tip.content($("#tips_id").html());
		} else {
			tip.content(json.error);
		}
		$('#_btn_close').bind('click', function() { tip.close(); });
	}, 'json');
}

//检查选购项
function checkBuychoose(params, callback)
{
	var flag = false;
	$.ajax({
		type:"POST",
		async:false,
		data:params,
		url:'/?controller=product&action=ajax_buychoose&callback='+callback
	}).done(function(result) {
		if (result == 'no') {
			flag = true;
		} else {
			flag = false;
			var cbc = art.dialog({
				id:'cartTip',
				title: '请选择您要购买的商品信息',
				fixed: true,
				lock: true
			});	
			cbc.content(result);
		}
	});
	return flag;
}

function quickLogin()
{
	$.ajax({
		type:"POST",
		async:false,
		url:'/?module=usercp&controller=passport&action=ajax_quick_login'
	}).done(function(result) {
		if (result == 'is_login') {
			flag = true;
		} else {
			flag = false;
			var cbc = art.dialog({
				id:'cartTip',
				title: '请登陆',
				fixed: true,
				lock: true
			});	
			cbc.content(result);
		}
	});
}

//检查登陆
function checkLogin(params, callback)
{
	var flag = false;
	$.ajax({
		type:"POST",
		async:false,
		data:params,
		url:'/?module=usercp&controller=passport&action=ajax_quick_login&callback='+callback
	}).done(function(result) {
		if (result == 'is_login') {
			flag = true;
		} else {
			flag = false;
			var cbc = art.dialog({
				id:'cartTip',
				title: '请登陆',
				fixed: true,
				lock: true
			});	
			cbc.content(result);
		}
	});
	return flag;
}

//从购物车中移除
function removeCart(mark, dom)
{
	var dom = dom||false;
	$.post('/?module=default&controller=cart&action=remove', {mark:mark}, function(result) {
		if (dom) {
			$(dom).remove();
			refreshTotal();
		}
		else {
			window.location.href = '/cart/';
		}
	});
}

//刷新购物车
function refreshTotal() {
	$.getJSON('/?controller=cart&action=total', function(json) {
		$('._total_quantity').html(json.total_quantity);
		$('._cart_total_qty').text(json.total_quantity);
		$('._total_weight').html(json.total_weight.toFixed(2));
		$('._total_save').html('&yen;'+json.total_save.toFixed(2));
		$('._total_amount').html('&yen;'+json.total_amount.toFixed(2));
		$("._total_use_coupon").html('&yen;'+json.total_use_coupon.toFixed(2));
		$('._total_freight').html('&yen;'+parseFloat(json.total_freight).toFixed(2));
		$('._total_earn_points').html(json.total_earn_points);
		$('._total_pay_amount').html('&yen;'+json.total_pay_amount.toFixed(2));
	});
}

//添加收藏夹
function addFavorite(title,url) { 
	if (window.sidebar) { 
		window.sidebar.addPanel(title,url,""); 
	}
	else if( document.all ) { 
		window.external.AddFavorite(url,title); 
	}
	else { 
		alert("您的浏览器暂不支持，请使用Ctrl+D进行添加！");
	} 
}

function checkSearch(obj, str) {
	var q = $(obj).find('input[name=q]');
	if (str == q.val() || q.val() == '') {
		alert('请输入您要查询的关键词！');
		q.focus().val();
		return false;
	}
}