function refreshProduct() {
	$.post('/?controller=product&action=ajax_refresh', $("#buy-form").serialize(), function(json) {
		$('._buychoose_text').text(json.buychoose);
		$('._quantity').text(json.quantity);
		$('._selling_price').text(json.prices.selling_price.toFixed(2));
		if (json.prices.card_vip_price) {
			$('._card_vip_price').text(json.prices.card_vip_price.toFixed(2));
		}
		$('._market_price').text(json.prices.market_price.toFixed(2));
		if (json.prices.promotion_price) {
			$('._promotion_price').text(json.prices.promotion_price.toFixed(2));
		}
		
		$('input[name=selling_price]').val(json.prices.selling_price);
		$('input[name=current_price]').val(json.prices.current_price);
		$('input[name=quantity]').val(json.quantity);
		$('.plus').attr('title', json.quantity);
		if (json.quantity < 1) { //&#561;&#48509;&#46521;&#9034;			$('._in_stock').hide(); $('._no_stock').show();
		} else { 
			$('._in_stock').show(); $('._no_stock').hide(); 
		}
		
		selectPackage();
	}, 'json');
}

//&#1121;function buychoose(t, key, ipt) {
	$(ipt).val('['+key+':'+$.trim($(t).text())+']');
	$(t).siblings('dd').removeClass('curr');
	$(t).addClass('curr');
	$('._buychoose_selected').show();
	refreshProduct();
}

//&#1121;&#791;&#9037;
function selectPackage() {
	var total = 0;
	var packageTotal = 0;
	var sp = Number($('input[name=selling_price]').val());
	var bp = Number($('input[name=base_price]').val());
	$('._package:checked').each(function(index, element) {
        var sellingPirce = $(this).attr('data-selling-price');
		var packagePrice = $(this).attr('data-package-price');
		total += Number(sellingPirce);
		packageTotal += Number(packagePrice);
    });
	$('._packageTotalAmount').text((packageTotal+bp).toFixed(2));
	$('._totalAmount').text((total+sp).toFixed(2));
}

//&#813;&#50421;&#53909;&#9788;&#1037;
function addFav(pid)
{
	if (!checkLogin({pid:pid}, 'addFav')) return;
	$.post('/?module=usercp&controller=favorite&action=add', {pid:pid}, function(result) {
		alert(result);
	});
}
//b&#52537;&#41138;
function buyNow(params)
{
	if (!checkBuychoose(params, 'buyNow')) return;
	$.post('/?controller=cart&action=append', params, function(json) {
		params += '&marks='+json.marks;
		if (!checkLogin(params, 'buyNow')) return;
		window.location = '/cart/checkout/marks--'+json.marks+'.html';
	}, 'json');
}

//&#813;&#50421;&#56954;&#943;&#15693;
function addCart(params)
{
	if (!checkBuychoose(params, 'addCart')) return;
	$.post('/?controller=cart&action=append', params, function(json) {
		var tip = art.dialog({
			title: '&#801;&#702;',
			id:'cartTip',
			fixed: true
		});
		var total_amount = json.total_amount - json.total_save;
		$('._cart_total_qty').text(json.total_quantity);
		$('._cart_total_amount').text(total_amount.toFixed(2));
		if (!json.error) {
			tip.content($("#tips_id").html());
		} else {
			tip.content(json.error);
		}
		$('#_btn_close').bind('click', function() { tip.close(); });
	}, 'json');
}

//&#52018;qfunction checkBuychoose(params, callback)
{
	var flag = false;
	$.ajax({
		type:"POST",
		async:false,
		data:params,
		url:'/?controller=product&action=ajax_buychoose&callback='+callback
	}).done(function(result) {
		if (result == 'no') {
			flag = true;
		} else {
			flag = false;
			var cbc = art.dialog({
				id:'cartTip',
				title: '&#491;&#1121;&#1329;&#314;&#1194;&#11588;&#588;&#439;&#1029;&#994;',
				fixed: true,
				lock: true
			});	
			cbc.content(result);
		}
	});
	return flag;
}

function quickLogin()
{
	$.ajax({
		type:"POST",
		async:false,
		url:'/?module=usercp&controller=passport&action=ajax_quick_login'
	}).done(function(result) {
		if (result == 'is_login') {
			flag = true;
		} else {
			flag = false;
			var cbc = art.dialog({
				id:'cartTip',
				title: '&#491;&#55788;
				fixed: true,
				lock: true
			});	
			cbc.content(result);
		}
	});
}

//&#52018;D&#189;
function checkLogin(params, callback)
{
	var flag = false;
	$.ajax({
		type:"POST",
		async:false,
		data:params,
		url:'/?module=usercp&controller=passport&action=ajax_quick_login&callback='+callback
	}).done(function(result) {
		if (result == 'is_login') {
			flag = true;
		} else {
			flag = false;
			var cbc = art.dialog({
				id:'cartTip',
				title: '&#491;&#55788;
				fixed: true,
				lock: true
			});	
			cbc.content(result);
		}
	});
	return flag;
}

//&#17657;&#41903;&#15702;&#435;&#54090;function removeCart(mark, dom)
{
	var dom = dom||false;
	$.post('/?module=default&controller=cart&action=remove', {mark:mark}, function(result) {
		if (dom) {
			$(dom).remove();
			refreshTotal();
		}
		else {
			window.location.href = '/cart/';
		}
	});
}

//&#738;&#1026;&#64757;
function refreshTotal() {
	$.getJSON('/?controller=cart&action=total', function(json) {
		$('._total_quantity').html(json.total_quantity);
		$('._cart_total_qty').text(json.total_quantity);
		$('._total_weight').html(json.total_weight.toFixed(2));
		$('._total_save').html('&yen;'+json.total_save.toFixed(2));
		$('._total_amount').html('&yen;'+json.total_amount.toFixed(2));
		$("._total_use_coupon").html('&yen;'+json.total_use_coupon.toFixed(2));
		$('._total_freight').html('&yen;'+parseFloat(json.total_freight).toFixed(2));
		$('._total_earn_points').html(json.total_earn_points);
		$('._total_pay_amount').html('&yen;'+json.total_pay_amount.toFixed(2));
	});
}

//&#813;&#50378;&#1394;&#1596;&#1037;
function addFavorite(title,url) { 
	if (window.sidebar) { 
		window.sidebar.addPanel(title,url,""); 
	}
	else if( document.all ) { 
		window.external.AddFavorite(url,title); 
	}
	else { 
		alert("&#314;&#61440;&#439;&#1309;&#11990;&#15111;&#45753;&#1219;Ctrl+D&#56848;&#1036;&#57107;&#14434;);
	} 
}

function checkSearch(obj, str) {
	var q = $(obj).find('input[name=q]');
	if (str == q.val() || q.val() == '') {
		alert('&#491;&#676;&#555;&#314;&#1194;&#10833;&#64836;&#52490;&#14439;);
		q.focus().val();
		return false;
	}
}