<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:Cong.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-13 22:20:15
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');
  /*
   * @since 0.9.5
   * 记录CONG开始运行的时间
   */
  $GLOBALS['cong_start_time'] = microtime(true);
  if (function_exists('memory_get_usage'))
      $GLOBALS['cong_start_memory_use'] = memory_get_usage();
  /**
   * 定义CONG系统结构，不允修改！
   */
  /* @var 日志目录 */
  define("CONG_LOG", CONG_ROOT . "log" . DS);
  /* @var 核心文件 */
  define("CONG_CORE", CONG_ROOT . "core" . DS);
  /* @var 配置文件 */
  define("CONG_CONFIG", CONG_ROOT . "config" . DS);
  /* @var 模型文件 */
  define("CONG_MODEL", CONG_ROOT . "model" . DS);
  /* @var 脚本文件 */
  define("CONG_SCRIPT", CONG_ROOT . "script" . DS);
  /* @var 语言文件 */
  define("CONG_LANG", CONG_ROOT . "language" . DS);
  /* @var 驱动文件 */
  define("CONG_DRIVE", CONG_ROOT . "drive" . DS);
  /* @var 钩子文件 */
  define("CONG_HOOK", CONG_ROOT . "hook" . DS);

  /**
   * 应用文件目录
   * 
   */
  /* @var 应用文件 */
  defined("MYAPP_APPS") ? true : define("MYAPP_APPS", MYAPP_ROOT . "apps" . DS);
  /* @var 配置文件 */
  defined("MYAPP_CONFIG") ? true : define("MYAPP_CONFIG", MYAPP_ROOT . "config" . DS);
  /* @var 日志目录 */
  defined("MYAPP_LOG") ? true : define("MYAPP_LOG", MYAPP_ROOT . "log" . DS);
  /* @var 脚本文件 */
  defined("MYAPP_SCRIPT") ? true : define("MYAPP_SCRIPT", MYAPP_ROOT . "script" . DS);
  /* @var 语言文件 */
  defined("MYAPP_LANG") ? true : define("MYAPP_LANG", MYAPP_ROOT . "language" . DS);
  /* @var 缓存文件 */
  defined("MYAPP_CACHE") ? true : define("MYAPP_CACHE", MYAPP_ROOT . "cache" . DS);
  /* @var 模板文件 */
  defined("MYAPP_TPL") ? true : define("MYAPP_TPL", MYAPP_ROOT . "template" . DS);
  /* @var 模型文件 */
  defined("MYAPP_MODEL") ? true : define("MYAPP_MODEL", MYAPP_ROOT . "model" . DS);
  /* @var 驱动文件 */
  defined("MYAPP_DRIVE") ? true : define("MYAPP_DRIVE", MYAPP_ROOT . "drive" . DS);
  /* @var 钩子文件 */
  defined("MYAPP_HOOK") ? true : define("MYAPP_HOOK", MYAPP_ROOT . "hook" . DS);

  /**
   * 
   * 自PHP5.4起系统默认关闭自动转义，CONG将设定为所有的版本都不转义。
   * 
   */
  ini_set('magic_quotes_runtime', 0);

  if (function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) {

      /**
       * php.net
       * @since 1.0.0
       * @param array $value
       * @return string
       */
      function stripslashes_gpc($value) {
          if (is_array($value)) {
              $value = array_map('stripslashes_gpc', $value);
          }
          else {
              $value = stripslashes($value);
          }
          return $value;

      }

      $_POST = array_map('stripslashes_gpc', $_POST);
      $_GET = array_map('stripslashes_gpc', $_GET);
      $_COOKIE = array_map('stripslashes_gpc', $_COOKIE);
      $_REQUEST = array_map('stripslashes_gpc', $_REQUEST);
  }
  /**
   * 加载运行前文件。
   * cong_.php
   */
  require CONG_CORE . 'cong_' . EXT;
  /**
   * 注册自动加载类函数
   * 错误处理函数
   */
  spl_autoload_register("CongAutoLoader");

  set_error_handler("CongErrorHandler");

  set_exception_handler("CongExceptionHandler");

  class CONG {

      /**
       *
       * @var array $_CFG
       */
      public $_CFG = array();

      /**
       *
       * @var string $_myapp
       */
      public $_MYAPP;

      /**
       *
       * @var string $_action
       */
      public $_ACTION;

      /**
       *
       * @var type 
       */
      public $_APP_PATH;

      /**
       *
       * @var instance $_myapp
       */
      public $MYAPP;

      /**
       *
       * @var object $_benchmark
       */
      public $_BENCHMARK;

      /**
       *
       * @var object $_route
       */
      public $_ROUTE;

      /**
       *
       * @var object
       */
      public $_HOOK;

      /**
       *
       * @var object
       */
      public $_LOG;
      static public $CONG;

      public function __construct() {
          self::$CONG = &$this;

      }

      static function CONG() {
          return self::$CONG;

      }

      /**
       * GO?
       */
      public function GO() {
          $this->INIT();
          $this->RUN();
          $this->OUTPUT();
          $this->END();

      }

      /**
       * 
       * 进行一些初始的设置
       * 
       */
      function INIT() {

          /**
           * LOAD BENCHMARK CLASS
           */
          $this->_BENCHMARK = new cong_benchmark;


          /**
           * LOAD CORE CONFIG FILE
           */
          $this->_CFG = loadConfig("config", "CONG:");

          /*
           * set timezone
           */

          TIMEZONE_SET($this->_CFG['date']['timezone']);

          /**
           * LOAD HOOK CLASS
           */
          $this->_HOOK = new cong_hook;
          /**
           * LOAD LOG CLASS
           */
          $this->_LOG = new cong_log;


          /**
           * SET HOOK POINT INIT 
           */
          $this->_HOOK->setHook("INIT_END");
          $this->_BENCHMARK->mark("init_end");

      }

      /**
       * 
       * @throws Exception
       */
      function RUN() {
          /**
           * 
           */
          $this->_ROUTE = new cong_route;

          $this->_APP_PATH = $this->_ROUTE->MYAPP_APPS_TRUE_PATH;

          $this->_MYAPP = $this->_ROUTE->APP;

          $this->_CFG["URL_ROOT"] = $this->_ROUTE->URL_ROOT;
          /**
           * 
           */
          $this->_BENCHMARK->mark("route_end");
          $this->_HOOK->setHook("AFTER_ROUTE");

          /**
           * THE APPLICATIONN FILE
           * 载入控制器文件                     
           * @since 1.0.5
           * 去除控制器前缀 “myapp_";
           */
          $_APPLICATION_FILE = MYAPP_APPS . $this->_APP_PATH . $this->_MYAPP . EXT;
          if (!file_exists($_APPLICATION_FILE)) {

              $this->_HOOK->setHook("APP_NOT_FOUND");

              if ($this->_CFG['application']['check']) {

                  throw new Exception("Application [$this->_MYAPP] IN [$this->_APP_PATH] not found!");
              }
              else {

                  if (isset($this->_CFG['application']['default']) && !empty($this->_CFG['application']['default'])) {
                      /**
                       * 默认控制器
                       * 
                       * @since 1.0.5
                       * 去除控制器前缀 “myapp_";
                       */
                      $_APPLICATION_FILE = MYAPP_APPS . $this->_CFG['application']['default'] . EXT;

                      $this->_MYAPP = $this->_CFG['application']['default'];
                  }
                  else {

                      $_APPLICATION_FILE = MYAPP_APPS . "index" . EXT;
                      $this->_MYAPP = "index";
                  }
              }
          }
          /**
           * 
           * 加载控制器文件
           */
          require $_APPLICATION_FILE;
          $this->_HOOK->setHook("APP_LOADED");
          $this->_BENCHMARK->mark("app_loaded");

          /**
           * 
           */
          $_APPLICATION_CLASS = "myapp_" . $this->_MYAPP;
          $this->MYAPP = new $_APPLICATION_CLASS;

          /**
           * 设定挂钩点，控制器载入完成。
           */
          $this->_HOOK->setHook("APP_INSTANCED");
          $this->_BENCHMARK->mark("app_instanced");

          /**
           * 
           */
          $this->_ACTION = "c_" . $this->_ROUTE->ACTION;

          /**
           * 执行ACTION，如果有缓存内容将终止ACTION直接跳转至 CONG->END()
           */
          $this->MYAPP->{$this->_ACTION}();

          /**
           * ACTION完成，设定挂钩点。
           */
          $this->_HOOK->setHook("ACTION_END");
          $this->_BENCHMARK->mark("action_end");

      }

      /**
       * 
       */
      function OUTPUT() {

          $this->_OUTPUT = new cong_output;

          $this->_OUTPUT->get();

          $this->_HOOK->setHook("CACHE");

          $this->MYAPP->CACHE->W($this->_OUTPUT->content);

          $this->_HOOK->setHook("CACHE_END");

          $this->_BENCHMARK->mark("cache_end");

          $this->_OUTPUT->flush();

          $this->_BENCHMARK->mark("display_end");

      }

      function END() {
          $this->_HOOK->setHook("LOG");
          /**
           * 
           */
          $this->_LOG->_SQL($this->MYAPP->DB->_sql);
          //OR
          isset($this->MYAPP) ? $this->_LOG->_SQL($this->MYAPP->DB->_sql) : null;

          /**
           * 
           */
          $this->_LOG->_GET();

          $this->_HOOK->setHook("CONG_END");

          $this->_BENCHMARK->display();

      }

  }
  /*
   * 实例化 CONG
   */
  $CONG = new CONG;
//END!不要在下面添加任何代码！