<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 1:23:53
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');


  /**
   * 如果应用目录不存在
   * 生成应用目录
   * 
   */
  is_file(MYAPP_ROOT . "dir.lock") ? TRUE : MK_APPDIR(MYAPP_ROOT);
  is_writable(MYAPP_ROOT) ? TRUE : die("Application directory is not writable");

  /**
   * CongMVC基础函数库。
   */
  function _get($str) {

      return isset($_GET[$str]) ? str_replace('$', '', $_GET[$str]) : null;

  }

  function post($val, $val) {

      $_POST[$var] = $val;

  }

  function _post($str) {

      return isset($_POST[$str]) ? $_POST[$str] : null;

  }

  function session($val, $val) {

      $_SESSION[$val] = $val;

  }

  function _session($str) {

      return isset($_SESSION[$str]) ? $_SESSION[$str] : null;

  }

  /**
   * @since 1.2.0
   * 设定COOKIE
   * @param string $name
   * @param type $value
   * @param int $expire
   * @param type $path
   * @param type $domain
   * @param type $secure
   */
  function cookie($name = NULL, $value = NULL, $expire = 0, $path = NULL, $domain = NULL, $secure = False) {

      setcookie($name, $value, time() + $expire, $path, $domain, $secure);

  }

  function _cookie($str) {

      return isset($_COOKIE[$str]) ? str_replace('$', '', $_COOKIE[$str]) : null;

  }

  function start_session() {

      if (!isset($_SESSION))
          session_start();

  }

  /**
   * @since 1.0.0
   * 生成应用目录
   */
  function MK_APPDIR() {

      /**
       * APP目录表
       */
      $APP_DIRS = array(MYAPP_ROOT,
            MYAPP_APPS,
            MYAPP_CACHE,
            MYAPP_CONFIG,
            MYAPP_DRIVE,
            MYAPP_HOOK,
            MYAPP_LANG,
            MYAPP_LOG,
            MYAPP_MODEL,
            MYAPP_SCRIPT,
            MYAPP_TPL);
      foreach ($APP_DIRS as $value) {
          /**
           * 目录是否存在？
           */
          is_dir($value) ? TRUE : mkdir($value);
      }

      /**
       * 写入锁定文件
       */
      $fp = fopen(MYAPP_ROOT . "dir.lock", "w");
      fclose($fp);
      /*
       * @since 1.0.6
       * 写入第一次运行演示文件。
       */
      $_TEMP_RUM = '<?php /*这是一个演示文件，THIS IS A FILE SHOW YOUR HOW TO USE*/ class myapp_index extends cong_myapp{ function c_test(){echo "This is a sampale";}}?>';
      file_exists(MYAPP_APPS . "index.php") ? true : file_put_contents(MYAPP_APPS . "index.php", $_TEMP_RUM);

  }

  /*   * ***************************************************************** */
  /*
   * @since 1.2.0
   * 开始系统函数库
   * 以字母排序。
   * 
   */
//A

  /**
   * 配置文件加载
   * @since 1.0.5 
   */
//C
  function clientIP($IPLevel = 'D') {
      $clientIP = $_SERVER["REMOTE_ADDR"];
      $IPArray = explode('.', $clientIP);
      switch ($IPLevel) {
          case 'D':$clientIP = $IPArray[0] . "." . $IPArray[1] . "." . $IPArray[2] . "." . $IPArray[3];
              break;
          case 'C':$clientIP = $IPArray[0] . "." . $IPArray[1] . "." . $IPArray[2] . "." . $IPArray[3] = 0;
              break;
          case 'B':$clientIP = $IPArray[0] . "." . $IPArray[1] . "." . $IPArray[2] = 0 . "." . $IPArray[3] = 0;
              break;
      }
      return $clientIP;

  }

  /**
   * 或许是我开始用PHP的第一个自己的函数。
   * 深埋在这里吧。
   * @param type $str
   * @param type $start
   * @param type $cut
   * @param type $charset
   * @return type
   */
  function cn_substr($str, $start, $cut, $charset = 'utf-8') {
      $rstr = "";
      $word = "";
      $wno = 0;
      for ($i = 0; $i < strlen($str);) {
          if (ord($str[$i]) <= 127 && ord($str[$i]) >= 0) {
              $word = substr($str, $i, 1);
              $i++;
              $rstr.=($wno >= $start && $wno < ($start + $cut)) ? $word : '';
              $wno++;
          }
          elseif (ord($str[$i]) <= 223 && ord($str[$i]) >= 194) {
              $word = substr($str, $i, 2);
              $i+=2;
              $rstr.=($wno >= $start && $wno < ($start + $cut)) ? $word : '';
              $wno++;
          }
          elseif (ord($str[$i]) <= 239 && ord($str[$i]) >= 224) {
              $word = substr($str, $i, 3);
              $i+=3;
              $rstr.=($wno >= $start && $wno < ($start + $cut)) ? $word : '';
              $wno++;
          }
          elseif (ord($str[$i]) >= 240) {
              $word = substr($str, $i, 4);
              $i+=4;
              $rstr.=($wno >= $start && $wno < ($start + $cut)) ? $word : '';
              $wno++;
          }
          if ($wno >= ($start + $cut)) {
              break;
          }
      }
      return $rstr;

  }

  /**
   * @since 0.5.0
   * @param string $className
   * @throws Exception
   */
  function CongAutoLoader($className) {

      /**
       * 
       */
      if (file_exists(CONG_CORE . $className . EXT)) {

          require CONG_CORE . $className . EXT;
      }
      else {

          /**
           * 
           */
          throw new Exception('Class file' . CONG_CORE . $className . EXT . 'not found');
      }

  }

  /**
   * 
   * @since 1.0.0
   * @param type $errno
   * @param type $errstr
   * @param type $errfile
   * @param type $errline
   * @return type
   */
  function CongErrorHandler($errno = NULL, $errstr = NULL, $errfile = NULL, $errline = NULL) {

      /**
       * 
       */
      $levels = array(
            E_ERROR => 'Error',
            E_WARNING => 'Warning',
            E_PARSE => 'Parsing Error',
            E_NOTICE => 'Notice',
            E_CORE_ERROR => 'Core Error',
            E_CORE_WARNING => 'Core Warning',
            E_COMPILE_ERROR => 'Compile Error',
            E_COMPILE_WARNING => 'Compile Warning',
            E_USER_ERROR => 'User Error',
            E_USER_WARNING => 'User Warning',
            E_USER_NOTICE => 'User Notice',
            E_STRICT => 'Runtime Notice'
      );

      /*
       * 如果这个错误类型没有包含在error_reporting里
       * @会修改错误级别
       */
      if (!(error_reporting() & $errno)) {

          return TRUE;
      }

      /**
       * 
       */
      foreach ($levels as $key => $value) {

          if ($key == $errno) {
              $errno = $value;
              break;
          }
      }

      /**
       * 
       */
      $errorData = array(
            'httpCode' => 500,
            'errno' => $errno,
            'errstr' => $errstr,
            'errfile' => $errfile,
            'errline' => $errline
      );

      /**
       * 
       */
      trigerError($errorData);

  }

  /**
   * @since 1.0.0
   * @param Exception $e
   */
  function CongExceptionHandler(Exception $e) {

      /**
       * 
       */
      $errorData = array(
            'httpCode' => 404,
            'errno' => 'Exception',
            'errstr' => $e->getMessage(),
            'errfile' => $e->getFile(),
            'errline' => $e->getLine()
      );

      /**
       * 
       */
      trigerError($errorData);

  }

//F
  /**
   * @since 1.2.0
   * @param type $variable
   * @return type
   */
  function f_addslashes($variable) {
      if (is_array($variable)) {
          foreach ($variable as $key => $value) {
              $variable[$key] = f_addslashes($value);
          }
      }
      else {
          $variable = addslashes($variable);
      }
      return $variable;

  }

  /**
   * @since 1.2.0
   * @param type $variable
   * @return type
   */
  function f_stripslashes($variable) {
      if (is_array($variable)) {
          foreach ($variable as $key => $value) {
              $variable[$key] = f_stripslashes($value);
          }
      }
      else {
          $variable = stripslashes($variable);
      }
      return $variable;

  }

//L
  /**
   * @since 1.1.0
   * 配置文件加载
   * @param type $name
   * @param type $path
   * @param type $call
   * @return boolean
   */
  function loadConfig($name, $path = "", $call = null) {

      $type = substr($path, 0, 5);
      if ($type == "CONG:") {

          $path = substr($path, 6) . DS;
          $config_file = CONG_CONFIG . $path . $name . EXT;
      }
      else {

          $path = $path . DS;
          $config_file = MYAPP_CONFIG . $path . $name . EXT;
      }
      if (file_exists($config_file)) {
          require $config_file;
          /**
           * CHECK $CALL IS NULL;
           */
          if (empty($call)) {
              $call = $name;
              $call = str_replace(".", "_", $call);
          }
          if (isset($$call)) {
              return $$call;
          }
          echo "Notice:The property " . $$call . " in Config file $name not found";
          return FALSE;
      }
      else {
          echo "Notice:Config $name in $path file not found";
          return FALSE;
      }

  }

//H

  /**
   * @Since 1.2.0
   * Header 跳转
   * @param string $str
   * @param int $httpCode
   */
  function headerLocation($Location = "./", $httpCode = '303') {

      header("Location: {$Location}", $replace = null, $httpCode);

  }

//J
  /**
   * @since 1.2.0
   * JS跳转。
   * @param string $url reload,replace,goback,url
   * @param string $msg
   * @param int $sec
   */
  function jsLocation($url = "./", $msg = '', $sec = 0) {
      $go = '';
      if ($msg) {
          $go = " <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />
                <script>alert(\"{$msg}\")</script>";
      }
      if ($url == "reload") {
          $location = "window.location.reload();";
      }
      elseif ($url == "replace") {
          $location = "window.location.replace(location.href);";
      }
      elseif ($url == "goback") {
          $location = "history.go(-1);";
      }
      else {
          $location = "window.location=\"{$url}\";";
      }
      $sec = isset($sec) ? $sec : 0 * 1000;
      $go .= "
    <script>
        function go(){
          $location
        }
        setTimeout('go()',{$sec});
    </script>";
      echo $go;

  }

//R
  /**
   * @since 1.2.0
   * 删除COOKIE
   * @param type $name
   */
  function RCookie($name) {
      setcookie($name, NULL, time() - 3600, '/');

  }

//S
//T
  /**
   * @since 1.0.5
   */
  function TIMEZONE_SET($value = "Asia/Shanghai") {
      date_default_timezone_set($value);

  }

  /**
   * @since 1.0.0
   * @param array $errorData 构造错误数据
   */
  function trigerError($errorData = array()) {
      /**
       * 构造错误数据
       */
      if (!is_array($errorData)) {
          $errorData = array(
                'httpCode' => 404,
                'errno' => null,
                'errstr' => $errorData,
                'errfile' => null,
                'errline' => null
          );
      }
      $_error = new cong_error($errorData);
      $_error->show();

  }
  