<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:benchmark.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 2:15:01
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   * Description of benchmark
   *
   * @author Administrator
   */
  class cong_benchmark {

      /**
       * @var string cong_start_time
       */
      public $cong_start_time;
      public $cong_start_memory_use;

      /**
       * $elapse=array(
       * 'flag'=>'elapse'
       * )
       * @var array $elapse
       */
      public $elapse = array();
      public $memory_use = array();

      function __construct() {

          /**
           * 
           */
          $this->cong_start_time = $GLOBALS['cong_start_time'];
          $this->cong_start_memory_use = isset($GLOBALS['cong_start_memory_use']) ? $GLOBALS['cong_start_memory_use'] : 0;
          /**
           * 
           */
          $this->benchmark("cong_start");
          $this->memory_use("cong_start");

      }

      /**
       * 
       * @param type $flag
       */
      function mark($flag = null) {
          $this->benchmark($flag);
          $this->memory_use($flag);

      }

      /**
       * 
       * @param type $flag
       * @return type
       */
      function getTime($flag = null) {
          if (isset($this->elapse['cong_elapse_' . $flag])) {
              return $this->elapse['cong_elapse_' . $flag];
          }

      }

      /**
       * 
       */
      function getElapseTime($flag = null) {
          if (isset($this->elapse['cong_elapse_' . $flag])) {
              return $this->elapse['cong_elapse_' . $flag];
          }

      }

      /**
       * 
       */
      function getMemoryUse($flag = "now") {
          $this->memory_use($flag);

      }

      /**
       * 
       * @param type $flag
       * @return type
       */
      function benchmark($flag = null) {
          return $this->elapse['cong_elapse_' . $flag] = sprintf('%0.3f', microtime(true) - $this->cong_start_time);

      }

      /**
       * 
       * @param type $flag
       * @return type
       */
      function memory_use($flag = null) {
          if ($this->cong_start_memory_use) {
              $suffix = 'KB';
              $_memory_use = (memory_get_usage()) / 1024;
              if ($_memory_use >= 1024) {
                  $_memory_use = $_memory_use / 1024;
                  $suffix = 'MB';
              }

              return $this->memory_use['cong_memory_user_' . $flag] = sprintf('%0.2f', $_memory_use) . $suffix;
          }

      }

      /**
       * @since 1.0.3
       */
      function display() {
          $_is_display = $GLOBALS["CONG"]->_CFG["benchmark"]["display"];
          if ($_is_display) {
              echo"<h3>在配置文件 Cong.config 中 Benchmark display = true 开启显示,花费时间</h3>";
              $i = 0;
              foreach ($this->elapse as $key => $v) {
                  $i++;
                  printf('<p style="font-size:12px;margin:1px;padding:0px 10px;;">[#' . $i . ']===========>[%0.4f]==========>[%s]</p>', $v, $key);
              }
              echo"<h3>在配置文件 Cong.config 中 Benchmark display = true 开启显示,内存使用</h3>";
              $i = 0;
              foreach ($this->memory_use as $key => $v) {
                  $i++;
                  printf('<p style="font-size:12px;margin:1px;padding:0px 10px;">[#' . $i . ']===========>[%s]==========>[%s]</p>', $v, $key);
              }
          }

      }

  }  