<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_cache.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 14:34:20
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   * Description of cong_cache
   *
   * @author Administrator
   */
  class cong_cache {

      /**
       *
       * @var instance of app
       */
      public $theApp;

      /**
       *
       * @var global config
       */
      public $_CFG;

      /**
       *
       * @var bool 
       */
      public $caching = 0;

      /**
       *
       * @var string
       */
      public $cache_dir;

      /**
       *
       * @var type 
       */
      public $filename;

      /**
       *
       * @var type 
       */
      public $cache_name;

      /**
       *
       * @var type 
       */
      public $_lifetime;

      /**
       *
       * @var type 
       */
      public $_lifetime_c;

      /**
       *
       * @var type 
       */
      public $_lifetime_str = "Off";

      /**
       *
       * @var array
       */
      private $cache_info;

      /**
       *
       * @var type 
       */
      public $content;

      /**
       *
       * @var type 
       */
      public $_content;

      /**
       *
       * @var type 
       */
      private $_ext;

      /**
       *
       * @var boolen 
       */
      public $_is_cached;

      /**
       *
       * @var string
       */
      private $crc32;

      /**
       *
       * @var string 
       */
      public $_error_;

      /**
       * 
       */
      function __construct() {

          /**
           * 
           */
          ob_get_level() > 1 ? TRUE : ob_start();

          /**
           * 
           */
          $this->theApp = cong_myapp::myapp_instance();

          /**
           * 
           */
          $this->_CFG = $this->theApp->_CFG;

          /**
           * 
           */
          $this->cache_dir = MYAPP_CACHE;

      }

      /**
       * cache 
       * @param type $filename
       * @param type $cache_lifetime_c
       * @param type $cache_type
       */
      function C($filename = null, $_lifetime_c = null, $cache_type = "file") {
          if ($filename) {
              $this->caching = 1;
              $this->filename = $filename;
              $this->_ext = $this->_CFG['CACHE']['suffix'];
              $this->cache_name = $this->_get_c_name($filename);
              $this->_lifetime = $this->_CFG['CACHE']['lifetime'];
              $this->_lifetime_c = $_lifetime_c;
              $this->I();
              if ($this->O()) {
                  $this->theApp->CONG->END();
                  exit;
              }
          }

      }

      /**
       * 
       * @param string $content
       */
      function W($content = null) {
          if (!$this->caching)
              return FALSE;
          $this->content = $content;
          $_cache_name = $this->cache_name;
          $_content = $this->cache_info . $this->content;
          if (@is_writable($this->cache_dir)) {
              $fd = @fopen($this->cache_dir . $_cache_name . $this->_ext, 'wb');
              fwrite($fd, $_content);
              fclose($fd);
          }

      }

      /**
       * read cache
       */
      function R() {
          
      }

      /**
       * output cache
       */
      function O() {
          if ($this->is_cached($this->cache_name)) {
              $output = ob_get_contents();
              $output .= $this->_content;
              ob_end_clean();
              $this->theApp->CONG->_BENCHMARK->mark("cache_read");
              $elapse = $this->theApp->CONG->_BENCHMARK->getTime("cache_read");
              echo str_replace('CONG_TIMER', sprintf('Processed in %0.4fs ,Querys:%d ,'
                              , $elapse, $this->theApp->DB->icount), $output);
              return TRUE;
          }
          else {
              return false;
          }

      }

      /**
       * delete cache
       */
      function D($filenames = "all") {
          $this->theApp->load->script("cong.func.file");
          if (is_dir($this->cache_dir) && is_writable($this->cache_dir)) {
              chdir($this->cache_dir);
              $files = array();
              if (is_array($filenames)) {
                  foreach ($filenames as $filename) {
                      $files[] = self::cacheFilename($filename) . ".cache";
                  }
              }
              else {
                  if ($filenames == "all") {
                      $files = glob("*.cache");
                  }
                  else {
                      $files[] = self::cacheFilename($filenames) . ".cache";
                  }
              }
              CMVCDelete($files);
          }

      }

      function I() {
          $cach_info = array();
          /**
           * 
           */
          if ($this->_lifetime_c != null) {
              $this->_lifetime = $this->_lifetime_c;
              if ($this->_lifetime_c == "-1") {
                  $cach_info["expires"] = "-1";
                  $this->_lifetime_str = $cach_info["expires_date"] = "Never";
              }
              else {
                  $cach_info["expires"] = $this->_lifetime_c + time();
                  $cach_info["expires_date"] = date("r", $cach_info["expires"]);
              }
          }
          else {
              $cach_info["expires"] = $this->_lifetime + time();
              $cach_info["expires_date"] = date("r", $cach_info["expires"]);
          }
          /**
           * 
           */
          $_crc32 = sprintf('%08X', crc32($this->cache_dir . $this->filename . $this->_lifetime));
          $cach_info["crc32"] = $this->crc32 = $_crc32;
          $this->cache_info = serialize($cach_info) . "#";
          /**
           * 
           */
          if ($this->_lifetime < 0) {

              $this->_lifetime_str = "Nerver";
          }
          elseif ($this->_lifetime >= 0 && $this->_lifetime < 60) {

              $this->_lifetime_str = $this->_lifetime . "s";
          }
          elseif ($this->_lifetime >= 60 && $this->_lifetime < 3600) {

              $this->_lifetime_str = ($this->_lifetime / 60) . " Mins";
          }
          elseif ($this->_lifetime >= 3600) {

              $this->_lifetime_str = ($this->_lifetime / 3600) . " Hours";
          }

      }

      /**
       * 
       * @param string $filename
       * @return string
       */
      function _get_c_name($filename) {
          $_filename = urlencode(basename($filename));
          $_return = '';
          $_crc32 = sprintf('%08X', crc32($filename));
          // prepend %% to avoid name conflicts with
          // with $params['auto_id'] names
          $_crc32 = substr($_crc32, 0, 2) . substr($_crc32, 2, 4) . $_crc32;
          $_return .= '%%' . $_crc32 . '%%';
          return $_return;

      }

      function is_cached() {
          if (file_exists($this->cache_dir . $this->cache_name . $this->_CFG['CACHE']['suffix'])) {
              $this->theApp->LOAD->script("cong.func.file");
              $this->_content = CMVCGetFileContents($this->cache_dir . $this->cache_name . $this->_CFG['CACHE']['suffix']);
              if ($this->checkCache()) {
                  $this->_is_cached = TRUE;
                  return TRUE;
              }
              else {
                  $this->_error_ = "Cache not checked";
                  $this->_is_cached = FALSE;
                  return FALSE;
              }
          }
          else {
              $this->_is_cached = FALSE;
              $this->_error_ = "Cache file not found";
              return FALSE;
          }

      }

      function checkCache() {
          $cache_info = array();
          $cached_content = $this->_content;
          $h = strpos($cached_content, "#");
          $_cache_info = substr($cached_content, 0, $h);
          $this->_content = substr($cached_content, $h + 1);
          $cache_info = unserialize($_cache_info);
          /*
           * 检查缓存过期
           */
          if ($this->crc32 == $cache_info["crc32"]) {
              if ($cache_info["expires"] == "-1") {
                  return TRUE;
              }
              else {
                  if (time() <= $cache_info["expires"]) {
                      return true;
                  }
                  else {
                      return FALSE;
                  }
              }
          }
          else {
              return FALSE;
          }

      }

  }  