<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_db.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 14:12:20
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */

  /**
   * Description of cong_db
   *
   * @author Administrator
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  class cong_db {

      public $dbhost = ''; //主机地址
      public $dbuser = ''; //用户名
      public $dbpwd = ''; //数据库密码
      public $dbname = ''; //数据库名
      public $dblink = ''; //连接标识
      public $result = ''; //结果集
      public $affect = 0; //影响结果数
      public $debug = 0; //影响结果数
      public $last_insert_id = 0;
      public $table_array = array();
      public $values_array = array();
      public $condition_array = array();
      public $icount = 0; //查询次数
      public $_sql = array();

      /**
       * 
       * @param type $database
       * @param type $user
       * @param type $pwd
       * @param type $host
       * @param type $charset
       */
      function __construct($database = "test", $user = 'root', $pwd = 'root', $host = 'localhost', $charset = 'utf8') {
          $this->dbhost = $host;
          $this->dbname = $database;
          $this->dbuser = $user;
          $this->dbpwd = $pwd;
          $this->dbConnect();
          $this->selectDB();
          $this->query("SET character_set_connection={$charset}, character_set_results=utf8, character_set_client=binary", $this->dblink);
          $this->_sql = null;

      }

      /**
       * 
       * 链接数据库
       */
      function dbConnect() {
          if (!$this->dblink = mysql_connect($this->dbhost, $this->dbuser, $this->dbpwd))
              throw new Exception("CMVC cannot connect to Database Server[" . $this->dbhost . "]");

      }

      /**
       * 
       * 选择数据库
       */
      function selectDB() {
          if (!mysql_select_db($this->dbname, $this->dblink))
              throw new Exception("CMVC cannot change to database[$this->dbname]");

      }

      /**
       * 
       * 发送sql语句
       */
      function query($sql) {
          /**
           * 
           */
          $_start_ = microtime(true);

          /**
           * 
           */
          $sql = str_replace('#@', strtolower(SQL_PREFIX), $sql);

          /**
           * 
           */
          /**
           * 
           */
          if (!$result = mysql_query($sql, $this->dblink)) {
              $_mysql_error = mysql_error();
              throw new Exception("QUERY FAIL:{$sql}<br/>MYSQL ERROR:$_mysql_error");
          }

          $this->table_array = array();
          $this->values_array = array();
          $this->condition_array = array();
          /**
           * 
           */
          $this->insert_id = mysql_insert_id();
          /**
           * 
           */
          $this->_sql["log_" . $this->icount]["elapse"] = sprintf("%0.5f", microtime(true) - $_start_);
          $this->_sql["log_" . $this->icount]["sql"] = "[" . date("Y/m/d H:i:s") . "]" . $sql;


          /**
           * display debug
           */
          if ($this->debug) {
              echo '<p>[Waste:' . $this->_sql["log_" . $this->icount]["elapse"] . ']SQL:' . $sql . '</p>';
          }
          /**
           * 
           */
          $this->icount++;
          $this->debug = 0;
          return $result;

      }

      /**
       * 
       */
      function Debug() {
          $this->debug = 1;

      }

      /**
       * 
       * 各种sql操作
       */
      protected function valuesSQL($type) {
          $values_array = $this->values_array;

          /**
           * 
           * 
           */
          if ($type == "insert") {

              $SQL = "(" . $values_array[0][0];
              for ($i = 1; !empty($values_array[$i]); $i++) {
                  $SQL.="," . $values_array[$i][0];
              }
              $SQL.=")VALUES(" . sprintf($values_array[0][1], $values_array[0][2]);
              for ($i = 1; !empty($values_array[$i]); $i++) {
                  $SQL.="," . sprintf($values_array[$i][1], $values_array[$i][2]);
              }
              $SQL.=")";
          }

          /**
           * 
           * 
           */
          if ($type == "update") {
              $SQL = $values_array[0][0] . " = " . sprintf($values_array[0][1], $values_array[0][2]);
              for ($i = 1; !empty($values_array[$i]); $i++) {
                  $SQL.=", " . $values_array[$i][0] . " = " . sprintf($values_array[$i][1], $values_array[$i][2]);
              }
          }

          /**
           * 
           * 
           */
          if ($type == "select") {
              $SQL = $values_array[0][0];
              for ($i = 1; !empty($values_array[$i]); $i++) {
                  $SQL.="," . $values_array[$i][0];
              }
          }

          /*
           * 
           */
          return $SQL;

      }

      /**
       * 
       * @param type $sql
       * 
       */
      function select($sql) {
          $this->result = $this->query($sql);

      }

      /**
       * 
       * @param type $table
       * 
       */
      function setTable($table) {
          $this->table_array[] = $table;

      }

      /**
       * 
       * @return string
       * 
       */
      function getTable() {
          $tables = $this->table_array;
          $SQL = $tables[0];
          for ($i = 1; !empty($tables[$i]); $i++) {
              $SQL.="," . $tables[$i] . " ";
          }
          return $SQL;

      }

      /**
       * 
       * @param type $how
       * @param type $conditionFormat
       * @param type $value
       * 
       */
      function setCondition($how, $conditionFormat, $value = null) {
          $this->condition_array[] = array($how, $conditionFormat, $value);

      }

      /**
       * 
       * @return type
       * 
       */
      protected function Condition() {
          $condition_array = $this->condition_array;
          //var_dump($condition_array);
          $SQL = "";
          /**
           * 
           * 
           */
          for ($i = 0; !empty($condition_array[$i]); $i++) {
              if (strtolower($condition_array[$i][0]) == "join") {
                  $SQL.= " " . sprintf($condition_array[$i][1], $condition_array[$i][2]);
              }
          }
          /**
           * 
           * 
           */
          for ($i = 0; !empty($condition_array[$i]); $i++) {
              if (strtolower($condition_array[$i][0]) == "where") {
                  $SQL.= " WHERE " . sprintf($condition_array[$i][1], $condition_array[$i][2]);
              }
          }

          /**
           * 
           * 
           */
          for ($i = 0; !empty($condition_array[$i]); $i++) {
              if (strtolower($condition_array[$i][0]) == "and") {
                  $SQL.= " AND " . sprintf($condition_array[$i][1], $condition_array[$i][2]);
              }
          }

          /**
           * 
           * 
           */
          for ($i = 0; !empty($condition_array[$i]); $i++) {
              if (strtolower($condition_array[$i][0]) == "or") {
                  $SQL.= " OR " . sprintf($condition_array[$i][1], $condition_array[$i][2]);
              }
          }

          /**
           * 
           * 
           */
          for ($i = 0; !empty($condition_array[$i]); $i++) {
              if (strtolower($condition_array[$i][0]) == "not") {
                  $SQL.= " NOT " . sprintf($condition_array[$i][1], $condition_array[$i][2]);
              }
          }

          /**
           * 
           * 
           */
          for ($i = 0; !empty($condition_array[$i]); $i++) {
              if (strtolower($condition_array[$i][0]) == "order by") {
                  $SQL.= " ORDER BY " . sprintf($condition_array[$i][1], $condition_array[$i][2]);
              }
          }

          /**
           * 
           * 
           */
          for ($i = 0; !empty($condition_array[$i]); $i++) {
              if (strtolower($condition_array[$i][0]) == "limit") {
                  $SQL.= " Limit " . sprintf($condition_array[$i][1], $condition_array[$i][2]);
              }
          }
          //$SQL = "WHRER ID = 1";
          return " " . $SQL;

      }

      /**
       * 
       * @param type $column
       * @param type $format
       * @param type $value
       * 
       */
      function setSelect($column, $format = "", $value = "") {
          $this->values_array[] = array($column, $format, $value);

      }

      /**
       * 
       * 
       */
      function doSelect() {
          $SQL = "SELECT " . $this->valuesSQL("select") . " FROM " . $this->getTable();
          $SQL.=$this->Condition();
          $this->result = $this->query($SQL);

      }

      /**
       * 
       * @param type $column
       * @param type $format
       * @param type $value
       * 
       */
      function setInsert($column, $format, $value) {
          $this->values_array[] = array($column, $format, $value);

      }

      /**
       * 
       * 
       */
      function doInsert() {
          $SQL = "INSERT INTO " . $this->getTable() . " " . $this->valuesSQL("insert");
          $this->query($SQL);
          $this->affect = '0';
          $this->affect = $this->affectedRows();

      }

      /**
       * 
       * @param type $column
       * @param type $format
       * @param type $value
       * 
       */
      function setUpdate($column, $format, $value = null) {
          $this->values_array[] = array($column, $format, $value);

      }

      /**
       * 
       * 
       */
      function doUpdate() {
          $SQL = "UPDATE " . $this->getTable() . " SET " . $this->valuesSQL("update") . " ";
          $SQL.=$this->Condition();
          $this->query($SQL);
          $this->affect = '0';
          $this->affect = $this->affectedRows();

      }

      /**
       * 
       * 
       */
      function doDelete() {
          $SQL = "DELETE FROM " . $this->getTable() . " ";
          $SQL.=$this->Condition();
          $this->query($SQL);
          $this->affect = '0';
          $this->affect = $this->affectedRows();

      }

      /*
       * $n值分别为 作为枚举数组 关联数组 二者都有
       *
       * $one = 'once' 的话 只取得一行结果集
       */

      function fetchArray($n = 2) {
          switch ($n) {
              case 0 : $type = MYSQL_NUM;
                  break;
              case 1 : $type = MYSQL_ASSOC;
                  break;
              case 2 : $type = MYSQL_BOTH;
                  break;
              default: $type = MYSQL_NUM;
          }
          $rows = $row = array();
          while ($row = mysql_fetch_array($this->result, $type)) {
              $rows[] = $row;
          }
          return $rows;

      }

      /**
       * 
       * @param type $type
       * @return type
       * 
       */
      function fetchOne($type = 2) {
          switch ($type) {
              case 0 : $type = MYSQL_NUM;
                  break;
              case 1 : $type = MYSQL_ASSOC;
                  break;
              case 2 : $type = MYSQL_BOTH;
                  break;
              default: $type = MYSQL_NUM;
          }
          return mysql_fetch_array($this->result, $type);

      }

      /**
       * 
       * 取得结果集行的数目
       */
      function numRows() {
          return mysql_num_rows($this->result);

      }

      /**
       * 
       * @return type
       *  取得结果集字段的数目
       */
      function numFields() {
          return mysql_num_fields($this->result);

      }

      /**
       * 
       * 
       * 返回影响记录数
       */
      function affectedRows() {
          return mysql_affected_rows($this->dblink);

      }

      /**
       * 
       * 释放资源
       */
      function free() {
          if (!empty($this->result)) {
              mysql_free_result($this->result); //释放结果集
          }
          //mysql_close($this->dblink); //关闭数据库连接

      }

  }
//END